/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsStream;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.ResultBindingImpl;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class QueryEngine
implements QueryExecution {
    Query query;
    static int queryCount = 0;
    boolean queryInitialised = false;
    int idQueryExecution;
    ResultsIterator resultsIter;
    long queryStartTime = -1L;

    public QueryEngine(Query q) {
        this.query = q;
        this.idQueryExecution = ++queryCount;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        if (this.query.getSource() == null) {
            if (this.query.sourceURL == null) {
                throw new QueryException("No model for query");
            }
            long startTime = System.currentTimeMillis();
            Model src = FileManager.get().loadModel(this.query.sourceURL, null);
            if (src == null) {
                throw new QueryException("Failed to load data source");
            }
            this.query.setSource(src);
            this.query.loadTime = System.currentTimeMillis() - startTime;
        }
        this.queryInitialised = true;
    }

    public QueryResults exec() {
        return this.exec(null);
    }

    public QueryResults exec(ResultBindingImpl startBinding) {
        this.resultsIter = null;
        try {
            this.init();
            this.resultsIter = new ResultsIterator(this.query, startBinding);
            return new QueryResultsStream(this.query, this, this.resultsIter);
        }
        catch (RuntimeException ex) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            throw ex;
        }
    }

    public void abort() {
        this.resultsIter.close();
    }

    public void close() {
        this.resultsIter.close();
    }

    static RDFNode convertGraphNodeToRDFNode(Node n, Model model) {
        if (n.isLiteral()) {
            return new LiteralImpl(n, (ModelCom)model);
        }
        if (n.isURI() || n.isBlank()) {
            return new ResourceImpl(n, (ModelCom)model);
        }
        if (n.isVariable()) {
            System.err.println("Variable unbound: " + n);
            return null;
        }
        System.err.println("Unknown node type for node: " + n);
        return null;
    }

    static Triple substituteIntoTriple(Triple t, ResultBinding binding) {
        if (binding == null) {
            return t;
        }
        boolean keep = true;
        Node subject = QueryEngine.substituteNode(t.getSubject(), binding);
        Node predicate = QueryEngine.substituteNode(t.getPredicate(), binding);
        Node object = QueryEngine.substituteNode(t.getObject(), binding);
        if (subject == t.getSubject() && predicate == t.getPredicate() && object == t.getObject()) {
            return t;
        }
        return new Triple(subject, predicate, object);
    }

    static Node substituteNode(Node n, ResultBinding binding) {
        if (!n.isVariable()) {
            return n;
        }
        String name = ((Node_Variable)n).getName();
        Object obj = binding.get(name);
        if (obj == null) {
            return n;
        }
        if (obj instanceof RDFNode) {
            return ((RDFNode)obj).asNode();
        }
        if (obj instanceof Node) {
            return (Node)obj;
        }
        System.err.println("Unknown object in binding: ignored: " + obj.getClass().getName());
        return n;
    }

    private static void printExpression(Expression e) {
        System.out.println("Expression: " + e + "  [" + e.getClass().getName() + "]");
        if (e.isApply()) {
            System.out.println("  Apply - " + e.getFun());
            for (int i = 0; i < e.argCount(); ++i) {
                QueryEngine.printExpression(e.getArg(i));
            }
        } else if (e.isVariable()) {
            System.out.println("  Variable - " + e.getName());
        } else if (e.isConstant()) {
            System.out.println("  Constant - " + e.getValue());
        } else {
            System.out.println("  Unknown");
        }
    }

    static class ResultsIterator
    implements ClosableIterator {
        Node[] projectionVars;
        Query query;
        ResultBindingImpl nextBinding = null;
        boolean finished = false;
        ClosableIterator planIter;
        ResultBindingImpl initialBindings;

        ResultsIterator(Query q, ResultBindingImpl presets) {
            this.query = q;
            this.initialBindings = presets;
            Graph graph = this.query.getSource().getGraph();
            QueryHandler queryHandler = graph.queryHandler();
            com.hp.hpl.jena.graph.query.Query graphQuery = new com.hp.hpl.jena.graph.query.Query();
            ListIterator iter = this.query.getTriplePatterns().listIterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                t = QueryEngine.substituteIntoTriple(t, presets);
                graphQuery.addMatch(t);
            }
            this.projectionVars = new Node[this.query.getBoundVars().size()];
            for (int i = 0; i < this.projectionVars.length; ++i) {
                this.projectionVars[i] = Node.createVariable((String)this.query.getBoundVars().get(i));
            }
            Iterator cIter = this.query.constraints.iterator();
            while (cIter.hasNext()) {
                Constraint constraint = (Constraint)cIter.next();
                if (constraint instanceof Expression) {
                    Expression e = (Expression)((Object)constraint);
                    graphQuery.addConstraint(e);
                    continue;
                }
                System.err.println("Query constraint '" + constraint + "' is not an expression");
            }
            BindingQueryPlan plan = queryHandler.prepareBindings(graphQuery, this.projectionVars);
            this.planIter = plan.executeBindings();
        }

        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            while (this.nextBinding == null && this.planIter.hasNext()) {
                Domain d = (Domain)this.planIter.next();
                this.nextBinding = new ResultBindingImpl(this.initialBindings);
                this.nextBinding.setQuery(this.query);
                for (int i = 0; i < this.projectionVars.length; ++i) {
                    String name = this.projectionVars[i].toString().substring(1);
                    Node n = (Node)d.get(i);
                    if (n == null) continue;
                    RDFNode rdfNode = QueryEngine.convertGraphNodeToRDFNode(n, this.query.getSource());
                    this.nextBinding.add(name, rdfNode);
                }
            }
            if (this.nextBinding == null) {
                this.close();
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.nextBinding == null) {
                throw new NoSuchElementException("QueryEngine.ResultsIterator");
            }
            ResultBindingImpl x = this.nextBinding;
            this.nextBinding = null;
            return x;
        }

        public void remove() {
            throw new UnsupportedOperationException("QueryEngine.ResultsIterator.remove");
        }

        public void close() {
            if (!this.finished) {
                this.planIter.close();
                this.finished = true;
            }
        }
    }
}

