/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;

public class RDFSCMPPreprocessHook
implements RulePreprocessHook {
    protected static String memberPrefix = RDF.getURI() + "_";

    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator it = dataFind.find(new TriplePattern(null, null, null));
        HashSet<Node> properties = new HashSet<Node>();
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            Node prop = triple.getPredicate();
            if (prop.equals(RDF.Nodes.type) && triple.getObject().equals(RDF.Nodes.Property)) {
                prop = triple.getSubject();
            }
            if (!properties.add(prop) || !prop.getURI().startsWith(memberPrefix)) continue;
            inserts.add(new Triple(prop, RDF.Nodes.type, RDFS.Nodes.ContainerMembershipProperty));
        }
    }

    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t) {
        return t.getPredicate().getURI().startsWith(memberPrefix);
    }
}

