% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset06}
\alias{dataset06}
\title{Magnus FROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:2, 1:4, 1:89, 1:17], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1:2, 1:4, 1:42, 1:15], of lesion localizations, LLs}
\item{\code{lesionVector}}{ array [1:42], number of lesions per diseased case}
\item{\code{lesionID}}{ array [1:42, 1:15], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:42, 1:15] weights (or clinical importance) of lesions, all set to 1}
\item{\code{dataType}}{ "FROC", the data type}
\item{\code{modalityID}}{ [1:2] "1" "2", treatment labels}
\item{\code{readerID}}{ [1:4] "1" "2" ..., reader labels}
}}
\usage{
dataset06
}
\description{
This is referred to in the book as the "MAG" dataset (after Magnus Bath, 
who conducted the JAFROC analysis). It consists of 100 cases, 69 of which are diseased, 
interpreted in two treatments ("1" = conventional chest, "1" = chest tomosynthesis) by four 
radiologists using the FROC paradigm.
}
\examples{
str(dataset06)
PlotEmpiricalOperatingCharacteristics(dataset = dataset06, opChType = "wAFROC")$Plot


}
\references{
Vikgren J  et al. Comparison of Chest Tomosynthesis and Chest Radiography 
for Detection of Pulmonary Nodules: Human Observer Study of Clinical Cases. 
Radiology. 2008;249(3):1034-1041.
}
\keyword{datasets}
