/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.exceptions;

import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxIOException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxResponseException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlParsingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public final class SdmxExceptionFactory {
    private static final Map<Integer, String> sdmxMessages = new HashMap<Integer, String>();

    private SdmxExceptionFactory() {
    }

    public static SdmxException createRestException(int n, IOException iOException, Provider provider) {
        String string;
        int n2 = SdmxExceptionFactory.translateCode(n);
        String string2 = string = provider != null ? null : null;
        if (string == null) {
            string = sdmxMessages.get(n2);
        }
        if (string == null) {
            return new SdmxInvalidParameterException("HTTP error code " + n2 + " doesn't have a defined SDMX meaning.");
        }
        SdmxResponseException sdmxResponseException = new SdmxResponseException(n2, iOException, "(" + n2 + "): " + sdmxMessages.get(n2));
        return sdmxResponseException;
    }

    private static int translateCode(int n) {
        switch (n) {
            case 400: {
                return 140;
            }
            case 401: {
                return 110;
            }
            case 403: {
                return 150;
            }
            case 404: {
                return 100;
            }
            case 413: {
                return 510;
            }
            case 500: 
            case 501: 
            case 503: {
                return n;
            }
        }
        return n;
    }

    public static SdmxException wrap(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof XMLStreamException) {
            if (exception.getCause() instanceof IOException) {
                return new SdmxIOException((XMLStreamException)exception);
            }
            return new SdmxXmlParsingException((XMLStreamException)exception);
        }
        if (exception instanceof IOException) {
            return new SdmxIOException((IOException)exception);
        }
        throw new IllegalStateException("Exception " + exception.getClass().getSimpleName() + " was not recognized.", exception);
    }

    static {
        sdmxMessages.put(100, "No results matching the query.");
        sdmxMessages.put(110, "Credentials needed.");
        sdmxMessages.put(130, "Results too large.");
        sdmxMessages.put(140, "There is a problem with the syntax of the query.");
        sdmxMessages.put(150, "The syntax of the query is OK but it has no meaning.");
        sdmxMessages.put(500, "Error on the provider side.");
        sdmxMessages.put(501, "Feature not supported.");
        sdmxMessages.put(503, "Service temporarily unavailable. Please try again later.");
        sdmxMessages.put(510, "Response too large.");
    }
}

