/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.DoubleObservation;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import it.bancaditalia.oss.sdmx.api.SdmxMetaElement;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LanguagePriorityList;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CompactDataParser
implements Parser<DataParsingResult> {
    private static final String sourceClass = CompactDataParser.class.getSimpleName();
    protected static final Logger logger = Configuration.getSdmxLogger();
    private static final String DATASET = "DataSet";
    private static final String ACTION = "action";
    private static final String VALID_FROM = "validFromDate";
    private static final String VALID_TO = "validToDate";
    private static final String SERIES = "Series";
    private static final String OBS = "Obs";
    private static final String FOOTER = "Footer";
    private static final String MESSAGE = "Message";
    private static final String CODE = "code";
    private static final String SEVERITY = "severity";
    private static final String TEXT = "Text";
    private DataFlowStructure dsd;
    private Dataflow dataflow;
    private boolean data;

    public CompactDataParser(DataFlowStructure dataFlowStructure, Dataflow dataflow, boolean bl) {
        this.dsd = dataFlowStructure;
        this.dataflow = dataflow;
        this.data = bl;
    }

    @Override
    public DataParsingResult parse(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        ArrayList<PortableTimeSeries<Double>> arrayList = new ArrayList<PortableTimeSeries<Double>>();
        DataParsingResult dataParsingResult = new DataParsingResult();
        PortableTimeSeries<Double> portableTimeSeries = null;
        String string = null;
        Object object = null;
        Object object2 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                Object object3;
                String string2;
                Object object4;
                Iterator<Attribute> iterator;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == DATASET) {
                    logger.finer("Got new dataset");
                    iterator = xMLEvent.getAttributes();
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        string2 = object4.getName().getLocalPart().toString();
                        object3 = object4.getValue();
                        if (string2.equalsIgnoreCase(ACTION)) {
                            logger.finer("action: " + (String)object3);
                            string = object3;
                            continue;
                        }
                        if (string2.equalsIgnoreCase(VALID_FROM)) {
                            logger.finer("VALID_FROM: " + (String)object3);
                            object = object3;
                            continue;
                        }
                        if (!string2.equalsIgnoreCase(VALID_TO)) continue;
                        logger.finer("VALID_TO: " + (String)object3);
                        object2 = object3;
                    }
                }
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    logger.finer("Got new time series");
                    portableTimeSeries = new PortableTimeSeries<Double>();
                    portableTimeSeries.setDataflow(this.dataflow);
                    iterator = xMLEvent.getAttributes();
                    this.setMetadata(portableTimeSeries, iterator, string, (String)object, (String)object2);
                }
                if (xMLEvent.getName().getLocalPart() == FOOTER) {
                    this.setFooter(xMLEventReader, languagePriorityList, dataParsingResult);
                }
                if (xMLEvent.getName().getLocalPart().equals(OBS) && this.data) {
                    xMLEvent2 = xMLEventReader.nextEvent();
                    logger.finest(xMLEvent2.toString());
                    iterator = xMLEvent.getAttributes();
                    object4 = null;
                    string2 = null;
                    object3 = new HashMap();
                    while (iterator.hasNext()) {
                        Codelist codelist;
                        SdmxAttribute sdmxAttribute;
                        Attribute attribute = iterator.next();
                        String string3 = attribute.getName().toString();
                        if (string3.equals(this.dsd.getTimeDimension())) {
                            object4 = attribute.getValue();
                            continue;
                        }
                        if (string3.equals("TIME") && object4 == null) {
                            object4 = attribute.getValue();
                            continue;
                        }
                        if (string3.equals(this.dsd.getMeasure())) {
                            string2 = attribute.getValue();
                            continue;
                        }
                        String string4 = attribute.getValue();
                        String string5 = null;
                        if (!Configuration.getCodesPolicy().equalsIgnoreCase(CODE) && (sdmxAttribute = this.dsd.getAttribute(string3)) != null && (codelist = sdmxAttribute.getCodeList()) != null && (string5 = codelist.get(string4)) != null) {
                            string4 = Configuration.getCodesPolicy().equalsIgnoreCase("description") ? string5 : string4 + "(" + string5 + ")";
                        }
                        object3.put(string3, string4);
                    }
                    try {
                        portableTimeSeries.add(new DoubleObservation((String)object4, Double.valueOf(string2), (Map<String, String>)object3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.fine("The date: " + (String)object4 + "has an obs value that is not parseable to a numer: " + string2 + ". A NaN will be set.");
                        portableTimeSeries.add(new DoubleObservation((String)object4, Double.NaN, (Map<String, String>)object3));
                    }
                    continue;
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES) continue;
            logger.finer("Adding time series " + portableTimeSeries);
            int n = portableTimeSeries.size();
            if (n > 1 && ((BaseObservation)portableTimeSeries.get(n - 1)).compareTo((BaseObservation<?>)portableTimeSeries.get(0)) < 0) {
                portableTimeSeries.reverse();
            }
            arrayList.add(portableTimeSeries);
        }
        dataParsingResult.setData(arrayList);
        logger.exiting(sourceClass, "parse");
        return dataParsingResult;
    }

    private void setMetadata(PortableTimeSeries<?> portableTimeSeries, Iterator<Attribute> iterator, String string, String string2, String string3) {
        Object object;
        logger.entering(sourceClass, "setMetadata");
        if (string != null) {
            portableTimeSeries.addAttribute(ACTION, string);
        }
        if (string2 != null) {
            portableTimeSeries.addAttribute(VALID_FROM, string2);
        }
        if (string3 != null) {
            portableTimeSeries.addAttribute(VALID_TO, string3);
        }
        int n = this.dsd.getDimensions().size();
        String[] stringArray = new String[n];
        Map.Entry[] entryArray = new Map.Entry[n];
        while (iterator.hasNext()) {
            Codelist codelist;
            SdmxMetaElement sdmxMetaElement;
            String string4;
            object = iterator.next();
            String string5 = object.getName().toString();
            String string6 = object.getValue();
            if (this.dsd.isDimension(string5)) {
                string4 = null;
                stringArray[this.dsd.getDimensionPosition((String)string5) - 1] = string5;
                if (string5.equalsIgnoreCase("FREQ") || string5.equalsIgnoreCase("FREQUENCY")) {
                    portableTimeSeries.setFrequency(string6);
                }
                if ((sdmxMetaElement = this.dsd.getDimension(string5)) != null && (codelist = sdmxMetaElement.getCodeList()) != null) {
                    string4 = codelist.get(string6);
                }
                entryArray[this.dsd.getDimensionPosition((String)string5) - 1] = new AbstractMap.SimpleEntry<String, String>(string6, string4);
                continue;
            }
            string4 = null;
            if (!Configuration.getCodesPolicy().equalsIgnoreCase(CODE) && (sdmxMetaElement = this.dsd.getAttribute(string5)) != null && (codelist = sdmxMetaElement.getCodeList()) != null && (string4 = codelist.get(string6)) != null) {
                string6 = Configuration.getCodesPolicy().equalsIgnoreCase("description") ? string4 : string6 + " (" + string4 + ")";
            }
            portableTimeSeries.addAttribute(string5, string6);
        }
        object = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            object.put(stringArray[i], entryArray[i]);
        }
        portableTimeSeries.setDimensions((Map<String, Map.Entry<String, String>>)object);
        logger.exiting(sourceClass, "setMetadata");
    }

    private void setFooter(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList, DataParsingResult dataParsingResult) throws XMLStreamException {
        logger.entering(sourceClass, "setFooter");
        Message message = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                Object object;
                Object object2;
                Object object3;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == MESSAGE) {
                    message = new Message();
                    object3 = xMLEvent.getAttributes();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        object = object2.getName().toString();
                        String string = object2.getValue();
                        if (((String)object).equalsIgnoreCase(CODE)) {
                            message.setCode(string);
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase(SEVERITY)) continue;
                        message.setSeverity(string);
                    }
                }
                if (xMLEvent.getName().getLocalPart() == TEXT) {
                    object3 = null;
                    object2 = new LocalizedText(languagePriorityList);
                    ((LocalizedText)object2).setText((StartElement)xMLEvent, xMLEventReader);
                    object3 = ((LocalizedText)object2).getText();
                    message.addText((String)object3);
                    try {
                        object = new URL((String)object3);
                        message.setUrl((String)object3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != MESSAGE) continue;
            logger.finer("Adding footer message");
            dataParsingResult.setMessage(message);
            break;
        }
        logger.exiting(sourceClass, "setFooter");
    }
}

