/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.tests;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import lombok.Generated;

public final class TradingDaysTests {
    public static StatisticalTest ftest(TsData s, boolean ar, int ny) {
        int ifreq = s.getFrequency().intValue();
        if (ar) {
            if (ny != 0) {
                s = s.drop(Math.max(0, s.getLength() - ifreq * ny - 1), 0);
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)TradingDaysTests.processAr(s));
        }
        s = s.delta(1);
        if (ny != 0) {
            s = s.drop(Math.max(0, s.getLength() - ifreq * ny), 0);
        }
        return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)TradingDaysTests.process(s));
    }

    private static ec.tstoolkit.stats.StatisticalTest process(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            y.add(-y.average());
            reg.setY(y);
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault((TradingDaysType)TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain();
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 0, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private static ec.tstoolkit.stats.StatisticalTest processAr(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            reg.setY(y.drop(1, 0));
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault((TradingDaysType)TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain().drop(1, 0);
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            reg.addX(y.drop(0, 1));
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            reg.setMeanCorrection(true);
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    @Generated
    private TradingDaysTests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

