/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;

public class Ols {
    private RegModel m_model;
    private ConcentratedLikelihood m_ll;

    public ConcentratedLikelihood getLikelihood() {
        return this.m_ll;
    }

    public RegModel getModel() {
        return this.m_model;
    }

    public DataBlock getResiduals() {
        return this.m_model.calcRes(new DataBlock(this.m_ll.getB()));
    }

    public boolean process(RegModel model) {
        this.m_model = model;
        this.m_ll = new ConcentratedLikelihood();
        Matrix x = model.variables();
        if (x == null) {
            return false;
        }
        int n = x.getRowsCount();
        int nx = x.getColumnsCount();
        DataBlock y = model.getY();
        if (nx > 0) {
            Householder qr = new Householder(true);
            try {
                Matrix bvar;
                qr.decompose(x);
                double[] res = new double[n - qr.getRank()];
                double[] b = new double[qr.getRank()];
                qr.leastSquares(y, new DataBlock(b), new DataBlock(res));
                double ssqerr = 0.0;
                for (int i = 0; i < res.length; ++i) {
                    ssqerr += res[i] * res[i];
                }
                double sig = ssqerr / (double)n;
                if (qr.getRank() > 0) {
                    Matrix u = UpperTriangularMatrix.inverse(qr.getR());
                    bvar = SymmetricMatrix.XXt(u);
                    bvar.mul(sig);
                } else {
                    bvar = null;
                }
                this.m_ll.set(ssqerr, 0.0, n);
                this.m_ll.setRes(res);
                int[] unused = qr.getUnused();
                if (unused != null) {
                    double[] bc = new double[nx];
                    Matrix bvarc = new Matrix(nx, nx);
                    int j = 0;
                    int k = 0;
                    for (int i = 0; i < nx; ++i) {
                        if (k < unused.length && i == unused[k]) {
                            ++k;
                            continue;
                        }
                        bc[i] = b[j];
                        int cj = 0;
                        int ck = 0;
                        for (int ci = 0; ci <= i; ++ci) {
                            if (ck < unused.length && ci == unused[ck]) {
                                ++ck;
                                continue;
                            }
                            double d = bvar.get(j, cj);
                            bvarc.set(i, ci, d);
                            bvarc.set(ci, i, d);
                            ++cj;
                        }
                        ++j;
                    }
                    b = bc;
                    bvar = bvarc;
                }
                this.m_ll.setB(b, bvar, qr.getRank());
                return true;
            }
            catch (BaseException ex) {
                return false;
            }
        }
        double ssqerr = y.ssq();
        double[] res = new double[y.getLength()];
        y.copyTo(res, 0);
        this.m_ll.setRes(res);
        this.m_ll.set(ssqerr, 0.0, n);
        return true;
    }
}

