/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.StringFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OutlierDefinition
implements Comparable<OutlierDefinition> {
    private final Day position;
    private final String code;

    public OutlierDefinition(TsPeriod period, OutlierType type) {
        this.position = period.firstday();
        this.code = type.name();
    }

    public OutlierDefinition(Day pos, OutlierType type) {
        this.position = pos;
        this.code = type.name();
    }

    public OutlierDefinition(TsPeriod period, String code) {
        this.position = period.firstday();
        this.code = code;
    }

    public OutlierDefinition(Day pos, String code) {
        this.position = pos;
        this.code = code;
    }

    public Day getPosition() {
        return this.position;
    }

    public OutlierType getType() {
        try {
            return OutlierType.valueOf(this.code);
        }
        catch (IllegalArgumentException ex) {
            return OutlierType.Undefined;
        }
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public int compareTo(OutlierDefinition o) {
        if (this.code.equals(o.code)) {
            return this.position.compareTo(o.position);
        }
        return this.code.compareTo(o.code);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof OutlierDefinition && this.equals((OutlierDefinition)obj);
    }

    private boolean equals(OutlierDefinition other) {
        return other.position.equals((Object)this.position) && other.code.equals(this.code);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.position);
        hash = 19 * hash + Objects.hashCode(this.code);
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.code).append('.').append(StringFormatter.convert(this.position));
        return builder.toString();
    }

    public String toString(TsFrequency freq) {
        if (freq == TsFrequency.Undefined) {
            return this.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.code).append('.').append(StringFormatter.write(new TsPeriod(freq, this.position)));
        return builder.toString();
    }

    public static OutlierDefinition fromString(String s) {
        Day day;
        String[] ss = InformationSet.split(s);
        if (ss.length != 2 && ss.length != 3) {
            return null;
        }
        OutlierType type = OutlierType.valueOf(ss[0]);
        if (type == null) {
            return null;
        }
        boolean p = false;
        if (ss.length == 3) {
            if (!ss[2].equals("f")) {
                return null;
            }
            p = true;
        }
        if ((day = StringFormatter.convertDay(ss[1])) != null) {
            return new OutlierDefinition(day, type);
        }
        TsPeriod period = StringFormatter.readPeriod(ss[1]);
        if (period != null) {
            return new OutlierDefinition(period, type);
        }
        return null;
    }

    public static List<OutlierDefinition> of(List<IOutlierVariable> vars) {
        ArrayList<OutlierDefinition> defs = new ArrayList<OutlierDefinition>();
        for (IOutlierVariable var : vars) {
            defs.add(new OutlierDefinition(var.getPosition(), var.getOutlierType()));
        }
        return defs;
    }
}

