/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.demetra;

import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.demetra.DemetraModule;
import ec.tstoolkit.timeseries.DayClustering;
import ec.tstoolkit.timeseries.calendars.GenericTradingDays;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.GenericTradingDaysVariables;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;

public class TradingDaysSelectionModule
extends DemetraModule
implements IPreprocessingModule {
    private static final String REGS = "Regression variables";
    private static final double DEF_MODEL_EPS = 0.01;
    private static final double DEF_CONSTRAINT_EPS = 0.01;
    private static final GenericTradingDays[] DEF_TD = new GenericTradingDays[]{GenericTradingDays.contrasts(DayClustering.TD7), GenericTradingDays.contrasts(DayClustering.TD4), GenericTradingDays.contrasts(DayClustering.TD3), GenericTradingDays.contrasts(DayClustering.TD2)};
    private final GenericTradingDays[] tdVars;
    private PreprocessingModel tdModel;
    private LikelihoodStatistics ntdStats;
    private LikelihoodStatistics[] tdStats;
    private final double pftd;
    private final double pfdel;
    private double[] pdel;
    private double[] ptd;
    private double[] bic;
    private double sigma;
    private static final double DEF_TVAL = 1.96;
    private double tval = 1.96;
    private int choice;

    public TradingDaysSelectionModule(double pftd, double pfdel) {
        this.pftd = pftd;
        this.pfdel = pfdel;
        this.tdVars = DEF_TD;
    }

    public TradingDaysSelectionModule(double pftd, double pfdel, GenericTradingDays[] td) {
        this.pftd = pftd;
        this.pfdel = pfdel;
        this.tdVars = td;
    }

    public double getPftd() {
        return this.pftd;
    }

    public double getTValue() {
        return this.tval;
    }

    public void setTvalue(double tval) {
        this.tval = tval;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        this.tdStats = new LikelihoodStatistics[this.tdVars.length];
        PreprocessingModel tdm = this.createModel(context, this.tdVars[0], LengthOfPeriodType.LeapYear);
        if (tdm == null) {
            return ProcessingResult.Failed;
        }
        this.tdModel = tdm;
        ConcentratedLikelihood ll = tdm.estimation.getLikelihood();
        this.tdStats[0] = tdm.estimation.getStatistics();
        int nhp = tdm.description.getArimaComponent().getFreeParametersCount();
        int df = ll.getN() - ll.getNx() - nhp;
        this.sigma = ll.getSsqErr() / (double)df;
        this.ntdStats = this.check(null, LengthOfPeriodType.LeapYear);
        for (int i = 1; i < this.tdVars.length; ++i) {
            this.tdStats[i] = this.check(this.tdVars[i], LengthOfPeriodType.LeapYear);
        }
        this.calcProb();
        boolean sel = false;
        this.choice = -1;
        for (int i = 0; i < this.pdel.length; ++i) {
            if (!(this.pdel[i] < this.pfdel) || !(this.ptd[i] < this.pftd)) continue;
            this.choice = i;
            break;
        }
        if (this.choice < 0 && this.ptd[this.pdel.length] < this.pftd) {
            this.choice = this.pdel.length;
        }
        GenericTradingDays best = this.choice < 0 ? null : this.tdVars[this.choice];
        this.tdModel = this.createModel(context, best, LengthOfPeriodType.LeapYear);
        if (best == null || !this.checkLY(this.tdModel)) {
            boolean mean = Math.abs(this.tdModel.estimation.getLikelihood().getTStats(true, 2)[0]) > 1.96;
            context.description = this.backModel(context, best, LengthOfPeriodType.None, mean);
        } else {
            boolean mean = Math.abs(this.tdModel.estimation.getLikelihood().getTStats(true, 2)[0]) > 1.96;
            context.description = this.backModel(context, best, LengthOfPeriodType.LeapYear, mean);
        }
        context.estimation = null;
        return ProcessingResult.Changed;
    }

    private void calcProb() {
        F fstat = new F();
        this.pdel = new double[this.tdVars.length - 1];
        this.ptd = new double[this.tdVars.length];
        this.bic = new double[this.tdVars.length + 1];
        int nhp = this.tdModel.description.getArimaComponent().getFreeParametersCount();
        ConcentratedLikelihood ll = this.tdModel.estimation.getLikelihood();
        int df = ll.getN() - ll.getNx() - nhp;
        fstat.setDFDenom(df);
        int nall = this.tdVars[0].getCount();
        double ftd = (this.ntdStats.SsqErr - this.tdStats[0].SsqErr) / ((double)nall * this.sigma);
        if (ftd > 0.0) {
            fstat.setDFNum(nall);
            this.ptd[0] = fstat.getProbability(ftd, ProbabilityType.Upper);
        }
        this.bic[0] = this.tdStats[0].BICC;
        this.bic[this.tdVars.length] = this.ntdStats.BICC;
        for (int i = 1; i < this.ptd.length; ++i) {
            double fcur;
            this.bic[i] = this.tdStats[i].BICC;
            int ncur = this.tdVars[i].getCount();
            int nprev = this.tdVars[i - 1].getCount();
            int ndel = nprev - ncur;
            double fdel = (this.tdStats[i].SsqErr - this.tdStats[i - 1].SsqErr) / ((double)ndel * this.sigma);
            if (fdel > 0.0) {
                fstat.setDFNum(ndel);
                this.pdel[i - 1] = fstat.getProbability(fdel, ProbabilityType.Upper);
            }
            if (!((fcur = (this.ntdStats.SsqErr - this.tdStats[i].SsqErr) / ((double)ncur * this.sigma)) > 0.0)) continue;
            fstat.setDFNum(ncur);
            this.ptd[i] = fstat.getProbability(fcur, ProbabilityType.Upper);
        }
    }

    private PreprocessingModel createModel(ModellingContext context, GenericTradingDays td, LengthOfPeriodType lp) {
        ModelDescription model = context.description.clone();
        model.setAirline(context.hasseas);
        model.setMean(true);
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (td != null) {
            GenericTradingDaysVariables vars = new GenericTradingDaysVariables(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        ModellingContext cxt = new ModellingContext();
        cxt.description = model;
        ModelEstimation estimation = new ModelEstimation(model.buildRegArima());
        int nhp = model.getArimaComponent().getFreeParametersCount();
        estimation.compute(this.monitor(), nhp);
        cxt.estimation = estimation;
        return cxt.current(true);
    }

    private LikelihoodStatistics check(GenericTradingDays td, LengthOfPeriodType lp) {
        ModelDescription model = this.tdModel.description.clone();
        model.removeVariable(var -> var.isCalendar());
        if (td != null) {
            GenericTradingDaysVariables vars = new GenericTradingDaysVariables(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        ModelEstimation estimation = new ModelEstimation(model.buildRegArima());
        int nhp = model.getArimaComponent().getFreeParametersCount();
        estimation.computeLikelihood(nhp);
        return estimation.getStatistics();
    }

    private ModelDescription backModel(ModellingContext context, GenericTradingDays td, LengthOfPeriodType lp, boolean mean) {
        ModelDescription model = context.description.clone();
        if (context.automodelling) {
            model.setMean(mean);
        }
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (td != null) {
            GenericTradingDaysVariables vars = new GenericTradingDaysVariables(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        return model;
    }

    private boolean checkLY(PreprocessingModel model) {
        boolean retval = true;
        ConcentratedLikelihood ll = model.estimation.getLikelihood();
        int start = model.description.getRegressionVariablesStartingPosition();
        TsVariableList x = model.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ILengthOfPeriodVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        double[] Tstat = ll.getTStats(true, 2);
        double t = Tstat[start + items[items.length - 1].position];
        if (Math.abs(t) < this.tval) {
            this.addLPInfo(model, t);
            retval = false;
        }
        return retval;
    }

    private void addLPInfo(PreprocessingModel model, double tstat) {
    }

    private void addEasterInfo(PreprocessingModel model, double tstat) {
    }

    private void addTDInfo(ModellingContext context, double pwd, double ptd, double pdel, int sel) {
    }

    public LikelihoodStatistics[] getTdStats() {
        return this.tdStats;
    }

    public double[] getPdel() {
        return this.pdel;
    }

    public double[] getPtd() {
        return this.ptd;
    }

    public int getChoice() {
        return this.choice;
    }

    public double[] getBic() {
        return this.bic;
    }

    public GenericTradingDays[] getTdVars() {
        return this.tdVars;
    }

    public PreprocessingModel getTdModel() {
        return this.tdModel;
    }

    public LikelihoodStatistics getNtdStats() {
        return this.ntdStats;
    }
}

