/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SsqNumericalDerivatives
implements ISsqFunctionDerivatives {
    private static final int nThreads = Runtime.getRuntime().availableProcessors();
    private double[] m_epsp;
    private double[][] m_ep;
    private double[] m_epsm;
    private double[][] m_em;
    private double[][] m_de;
    private double[] m_grad;
    private Matrix m_h;
    private final ISsqFunction m_fn;
    private IReadDataBlock m_pt;
    private double[] m_ecur;
    private final boolean m_sym;
    private final boolean m_mt;
    private static int g_nsteps = 2;

    public SsqNumericalDerivatives(ISsqFunction fn, ISsqFunctionInstance point) {
        this(fn, point, false, false);
    }

    public SsqNumericalDerivatives(ISsqFunction fn, ISsqFunctionInstance point, boolean sym, boolean mt) {
        this.m_sym = sym;
        this.m_mt = mt;
        this.m_fn = fn;
        this.m_ecur = point.getE();
        this.m_pt = point.getParameters();
    }

    public SsqNumericalDerivatives(ISsqFunction fn, ISsqFunctionInstance point, boolean sym) {
        this(fn, point, sym, false);
    }

    private void calcgrad() {
        int i;
        int n = this.m_pt.getLength();
        this.m_grad = new double[n];
        this.m_epsp = new double[n];
        this.m_ep = new double[n][];
        if (this.m_sym) {
            this.m_epsm = new double[n];
            this.m_em = new double[n][];
        }
        this.m_de = new double[n][];
        if (!this.m_mt || n < 2) {
            for (i = 0; i < n; ++i) {
                this.m_epsp[i] = this.m_fn.getDomain().epsilon(this.m_pt, i);
                this.checkepsilon(i);
                if (this.m_sym) {
                    this.checkmepsilon(i);
                }
                this.m_ep[i] = this.err(i, this.m_epsp[i]);
                if (!this.m_sym) continue;
                this.m_em[i] = this.err(i, this.m_epsm[i]);
            }
        } else {
            for (int i2 = 0; i2 < n; ++i2) {
                this.m_epsp[i2] = this.m_fn.getDomain().epsilon(this.m_pt, i2);
                this.checkepsilon(i2);
                if (!this.m_sym) continue;
                this.checkmepsilon(i2);
            }
            List<Callable<Void>> tasks = this.createTasks(n, this.m_sym);
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
            try {
                executorService.invokeAll(tasks);
                executorService.shutdown();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        for (i = 0; i < n; ++i) {
            double[] ep = this.m_ep[i];
            double gr = 0.0;
            double[] de = new double[this.m_ecur.length];
            for (int j = 0; j < this.m_ecur.length; ++j) {
                if (this.m_sym) {
                    double[] em = this.m_em[i];
                    de[j] = (ep[j] - em[j]) / (this.m_epsp[i] - this.m_epsm[i]);
                } else {
                    de[j] = (ep[j] - this.m_ecur[j]) / this.m_epsp[i];
                }
                gr += this.m_ecur[j] * de[j];
            }
            this.m_grad[i] = 2.0 * gr;
            this.m_de[i] = de;
        }
    }

    private void calch() {
        int i;
        if (this.m_grad == null) {
            this.calcgrad();
        }
        int n = this.m_grad.length;
        this.m_h = new Matrix(n, n);
        for (i = 0; i < n; ++i) {
            double h = 0.0;
            double[] de = this.m_de[i];
            for (int k = 0; k < de.length; ++k) {
                h += de[k] * de[k];
            }
            this.m_h.set(i, i, 2.0 * h);
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double h = 0.0;
                double[] dei = this.m_de[i];
                double[] dej = this.m_de[j];
                for (int k = 0; k < dei.length; ++k) {
                    h += dei[k] * dej[k];
                }
                this.m_h.set(i, j, 2.0 * h);
            }
        }
        SymmetricMatrix.fromLower(this.m_h);
    }

    private void checkepsilon(int i) {
        double eps = this.m_epsp[i];
        if (eps == 0.0) {
            return;
        }
        DataBlock pcur = new DataBlock(this.m_pt);
        double pi = pcur.get(i);
        pcur.add(i, eps);
        if (this.m_fn.getDomain().checkBoundaries(pcur)) {
            return;
        }
        int k = 0;
        do {
            pcur.set(i, pi + (eps /= 2.0));
        } while (++k <= g_nsteps && !this.m_fn.getDomain().checkBoundaries(pcur));
        if (k <= g_nsteps) {
            this.m_epsp[i] = eps;
            return;
        }
        eps = -this.m_epsp[i];
        pcur.set(i, pi + eps);
        if (this.m_fn.getDomain().checkBoundaries(pcur)) {
            this.m_epsp[i] = eps;
            return;
        }
        k = 0;
        do {
            pcur.set(i, pi + (eps /= 2.0));
        } while (++k <= g_nsteps && !this.m_fn.getDomain().checkBoundaries(pcur));
        if (k <= g_nsteps) {
            this.m_epsp[i] = eps;
            return;
        }
        this.m_epsp[i] = 0.0;
    }

    private void checkmepsilon(int i) {
        double eps = -this.m_epsp[i];
        DataBlock pcur = new DataBlock(this.m_pt);
        double pi = pcur.get(i);
        pcur.set(i, pi + eps);
        if (this.m_fn.getDomain().checkBoundaries(pcur)) {
            this.m_epsm[i] = eps;
        }
    }

    @Override
    public double[] dEdX(int idx) {
        if (this.m_de == null) {
            this.calcgrad();
        }
        return this.m_de[idx];
    }

    private double[] err(int i, double dx) {
        try {
            DataBlock pcur = new DataBlock(this.m_pt);
            pcur.add(i, dx);
            ISsqFunctionInstance fn = this.m_fn.ssqEvaluate(pcur);
            return fn.getE();
        }
        catch (Exception err) {
            return this.m_ecur;
        }
    }

    @Override
    public double[] getGradient() {
        if (this.m_grad == null) {
            this.calcgrad();
        }
        return this.m_grad;
    }

    @Override
    public void getJacobian(SubMatrix m) {
        if (this.m_de == null) {
            this.calcgrad();
        }
        for (int i = 0; i < this.m_de.length; ++i) {
            m.column(i).copyFrom(this.m_de[i], 0);
        }
    }

    @Override
    public Matrix getHessian() {
        if (this.m_h == null) {
            this.calch();
        }
        return this.m_h;
    }

    private List<Callable<Void>> createTasks(int n, boolean sym) {
        int i;
        ArrayList<Callable<Void>> result = new ArrayList<Callable<Void>>();
        for (i = 0; i < n; ++i) {
            result.add(new Err(this.m_ep, i, this.m_epsp[i]));
        }
        if (sym) {
            for (i = 0; i < n; ++i) {
                result.add(new Err(this.m_em, i, this.m_epsm[i]));
            }
        }
        return result;
    }

    private class Err
    implements Callable<Void> {
        double[][] rslt;
        int pos;
        double eps;

        private Err(double[][] rslt, int pos, double eps) {
            this.rslt = rslt;
            this.pos = pos;
            this.eps = eps;
        }

        @Override
        public Void call() throws Exception {
            try {
                DataBlock cur = new DataBlock(SsqNumericalDerivatives.this.m_pt);
                cur.add(this.pos, this.eps);
                ISsqFunctionInstance fn = SsqNumericalDerivatives.this.m_fn.ssqEvaluate(cur);
                this.rslt[this.pos] = fn.getE();
            }
            catch (Exception err) {
                this.rslt[this.pos] = SsqNumericalDerivatives.this.m_ecur;
            }
            return null;
        }
    }
}

