/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.utilities.Arrays2;

public abstract class AbstractSaSpecification {
    protected abstract void checkContext(ProcessingContext var1);

    protected static boolean checkVariables(TsVariableDescriptor[] vars, ProcessingContext context) {
        if (Arrays2.isNullOrEmpty(vars)) {
            return true;
        }
        if (context == null) {
            return false;
        }
        for (int i = 0; i < vars.length; ++i) {
            if (context.getTsVariable(vars[i].getName()) != null) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkVariables(String[] vars, ProcessingContext context) {
        if (Arrays2.isNullOrEmpty(vars)) {
            return true;
        }
        if (context == null) {
            return false;
        }
        for (int i = 0; i < vars.length; ++i) {
            if (context.getTsVariable(vars[i]) != null) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkCalendar(String calendar, ProcessingContext context) {
        if (calendar == null || calendar.isEmpty() || calendar.equals("Default")) {
            return true;
        }
        if (context == null) {
            return false;
        }
        GregorianCalendarManager mgr = context.getGregorianCalendars();
        return mgr.contains(calendar);
    }

    public IGregorianCalendarProvider getCalendar(String calendar, ProcessingContext context) {
        if (calendar == null || calendar.isEmpty() || calendar.equals("Default")) {
            return DefaultGregorianCalendarProvider.instance;
        }
        if (context == null) {
            return null;
        }
        GregorianCalendarManager mgr = context.getGregorianCalendars();
        return (IGregorianCalendarProvider)mgr.get(calendar);
    }
}

