/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.arima.estimation.ArmaKF;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Likelihood;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.IntList;
import java.util.ArrayList;
import java.util.Iterator;

public class SingleOutlierDetector2 {
    private ArrayList<IOutlierFactory> m_o = new ArrayList();
    private SarimaModel m_model;
    private SarimaModel m_stmodel;
    private BackFilter m_ur;
    private TsDomain m_domain;
    private double m_mad;
    private int m_lbound;
    private int m_ubound;
    private int m_posmax = -1;
    private int m_omax = -1;
    private double m_tmax;
    private double m_c;
    private IntList m_excluded = new IntList();
    private double[] m_el;
    private boolean m_bmad = true;
    private double m_ss;

    public void addOutlierFactory(IOutlierFactory o) {
        this.m_o.add(o);
        this.clear();
    }

    public boolean calc(IReadDataBlock sty) {
        if (!this.initialize(sty)) {
            return false;
        }
        this.m_c = 0.0;
        this.m_tmax = 0.0;
        for (int i = 0; i < this.getOutlierFactoriesCount(); ++i) {
            this.processOutlier(i);
        }
        return this.m_tmax > 0.0;
    }

    protected void clear() {
        this.m_mad = 0.0;
        this.m_omax = -1;
        this.m_posmax = -1;
    }

    public void clearOutlierFactories() {
        this.m_o.clear();
        this.clear();
    }

    public void exclude(int[] excl) {
        if (excl == null) {
            return;
        }
        for (int i = 0; i < excl.length; ++i) {
            this.m_excluded.add(excl[i]);
        }
    }

    public void exclude(IOutlierVariable o) {
        TsPeriod ostart = new TsPeriod(this.m_domain.getFrequency(), o.getPosition());
        this.m_excluded.add(ostart.minus(this.m_domain.getStart()));
    }

    public void allow(IOutlierVariable o) {
        TsPeriod ostart = new TsPeriod(this.m_domain.getFrequency(), o.getPosition());
        int pos = ostart.minus(this.m_domain.getStart());
        int xpos = -1;
        for (int i = 0; i < this.m_excluded.size(); ++i) {
            if (this.m_excluded.get(i) != pos) continue;
            xpos = i;
            break;
        }
        if (xpos >= 0) {
            this.m_excluded.remove(xpos);
        }
    }

    public void exclude(Iterator<IOutlierVariable> outliers) {
        while (outliers.hasNext()) {
            this.exclude(outliers.next());
        }
    }

    public TsDomain getDomain() {
        return this.m_domain;
    }

    public int getLBound() {
        return this.m_lbound;
    }

    public double getMAD() {
        return this.m_mad;
    }

    public double getMaxCoefficient() {
        return this.m_c;
    }

    public IOutlierVariable getMaxOutlier() {
        if (this.m_omax == -1) {
            return null;
        }
        return this.m_o.get(this.m_omax).create(this.m_domain.get(this.m_posmax));
    }

    public int getMaxOutlierType() {
        return this.m_omax;
    }

    public int getMaxPosition() {
        return this.m_posmax;
    }

    public double getMaxTStat() {
        return this.m_tmax;
    }

    public SarimaModel getModel() {
        return this.m_model;
    }

    public int getOutlierFactoriesCount() {
        return this.m_o.size();
    }

    public IOutlierFactory getOutlierFactory(int i) {
        return this.m_o.get(i);
    }

    public int getUBound() {
        return this.m_ubound;
    }

    public boolean initialize(IReadDataBlock y) {
        ArmaKF kf = new ArmaKF(this.m_stmodel);
        Likelihood ll = new Likelihood();
        if (!kf.process(y, ll)) {
            return false;
        }
        this.m_el = ll.getResiduals();
        this.setMAD(AbstractOutlierVariable.mad(new DataBlock(this.m_el), true));
        ll.getSsqErr();
        return true;
    }

    private boolean[] prepare(int i) {
        int j;
        boolean[] ok = new boolean[this.m_domain.getLength()];
        IOutlierFactory fac = this.getOutlierFactory(i);
        TsDomain dom = fac.definitionDomain(this.m_domain);
        int jstart = dom.getStart().minus(this.m_domain.getStart());
        int jend = dom.getLast().minus(this.m_domain.getStart());
        for (j = jstart; j <= jend; ++j) {
            ok[j] = true;
        }
        for (j = 0; j < this.m_excluded.size(); ++j) {
            ok[this.m_excluded.get((int)j)] = false;
        }
        return ok;
    }

    public void prepare(TsDomain estimationdomain, TsDomain outliersdomain) {
        this.m_domain = estimationdomain;
        if (outliersdomain == null) {
            this.m_lbound = 0;
            this.m_ubound = estimationdomain.getLength();
        } else {
            TsDomain common = estimationdomain.intersection(outliersdomain);
            this.m_lbound = outliersdomain.getStart().minus(common.getStart());
            this.m_ubound = this.m_lbound + common.getLength();
        }
        this.m_excluded.clear();
    }

    public boolean process(SarimaModel model, IReadDataBlock sty) {
        this.m_model = model;
        StationaryTransformation st = this.m_model.stationaryTransformation();
        this.m_stmodel = (SarimaModel)st.stationaryModel;
        this.m_ur = st.unitRoots;
        this.clear();
        return this.calc(sty);
    }

    private void processOutlier(int idx) {
        int i;
        int nl = this.m_el.length;
        int d = this.m_ur.getDegree();
        int n = nl + d;
        double[] o = new double[2 * n - 1];
        double[] ol = new double[o.length];
        DataBlock O = new DataBlock(o);
        DataBlock OL = new DataBlock(ol);
        IOutlierVariable outlier = this.getOutlierFactory(idx).create(this.getDomain().getStart());
        TsPeriod ostart = this.getDomain().getStart().minus(n - 1);
        outlier.data(ostart, O);
        this.m_model.getAR().filter(O, OL);
        this.m_model.getMA().solve(ol, o);
        int xstart = 0;
        int xend = o.length;
        for (i = 0; i < o.length; ++i) {
            if (o[i] == 0.0) continue;
            xstart = i;
            break;
        }
        for (i = o.length; i > 0; --i) {
            if (o[i - 1] == 0.0) continue;
            xend = i;
            break;
        }
        double sxx = 0.0;
        for (int i2 = Math.max(d, xstart); i2 < Math.min(n, xend); ++i2) {
            sxx += o[i2] * o[i2];
        }
        boolean[] ok = this.prepare(idx);
        for (int ix = 0; ix < n; ++ix) {
            double rmse = this.rmse(n - ix - 1 - d);
            if (ok[n - 1 - ix]) {
                double sxy = 0.0;
                int kstart = Math.max(xstart, d + ix);
                int kend = Math.min(n + ix, xend);
                for (int k = kstart; k < kend; ++k) {
                    sxy += o[k] * this.m_el[k - d - ix];
                }
                double c = sxy / sxx;
                double val = c * Math.sqrt(sxx) / rmse;
                double aval = Math.abs(val);
                if (aval > this.m_tmax) {
                    this.m_tmax = aval;
                    this.m_c = c;
                    this.m_posmax = n - 1 - ix;
                    this.m_omax = idx;
                }
            }
            if (ix >= n - 1) continue;
            int z = n + ix;
            if (z < xend) {
                sxx += o[z] * o[z];
            }
            if ((z -= nl) < xstart) continue;
            sxx -= o[z] * o[z];
        }
    }

    protected double rmse(int i) {
        if (this.m_bmad) {
            return this.getMAD();
        }
        if (this.m_ss == 0.0) {
            this.m_ss = new DataBlock(this.m_el).ssq();
        }
        if (i >= 0) {
            double ss = (this.m_ss - this.m_el[i] * this.m_el[i]) / (double)(this.m_el.length - 1);
            return Math.sqrt(ss);
        }
        return Math.sqrt(this.m_ss / (double)(this.m_el.length - 1));
    }

    public void setMAD(double value) {
        this.m_mad = value;
    }
}

