/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class SemiInfiniteSampleForecast {
    private double m_mean;
    private double m_stdev = 1.0;
    private double[] m_z;
    private double[] m_res;
    private IArimaModel m_model;
    private int m_nf;
    private double[] m_f;
    private double[] m_ef;

    private boolean calc() {
        if (this.m_f != null || this.m_model == null || this.m_nf == 0) {
            return false;
        }
        Polynomial phi = this.m_model.getAR().getPolynomial();
        int p = phi.getDegree();
        Polynomial theta = this.m_model.getMA().getPolynomial();
        this.m_f = new double[this.m_nf];
        for (int i = 0; i < this.m_nf; ++i) {
            int j;
            double z = this.m_mean;
            int j2 = i + 1;
            int k = this.m_res.length - 1;
            while (j2 <= theta.getDegree()) {
                z += theta.get(j2) * this.m_res[k];
                ++j2;
                --k;
            }
            int jmax = i > p ? p : i;
            for (j = 1; j <= jmax; ++j) {
                z -= this.m_f[i - j] * phi.get(j);
            }
            j = jmax + 1;
            int k2 = this.m_z.length - 1;
            while (j <= p) {
                z -= this.m_z[k2] * phi.get(j);
                ++j;
                --k2;
            }
            this.m_f[i] = z;
        }
        double[] psi = this.m_model.getPsiWeights().getWeights(this.m_nf);
        this.m_ef = new double[this.m_nf];
        this.m_ef[0] = this.m_stdev;
        double var = 1.0;
        for (int i = 1; i < this.m_nf; ++i) {
            this.m_ef[i] = Math.sqrt(var += psi[i] * psi[i]) * this.m_stdev;
        }
        return true;
    }

    private void clearresults() {
        this.m_f = null;
        this.m_ef = null;
    }

    public int getForecastHorizon() {
        return this.m_nf;
    }

    public double[] getForecasts() {
        return this.m_f;
    }

    public double[] getForecastsStdev() {
        return this.m_ef;
    }

    public double getMeanCorrection() {
        return this.m_mean;
    }

    public IArimaModel getModel() {
        return this.m_model;
    }

    public boolean process(double[] z, double[] res, double mean, double stdev) {
        int n = res.length;
        if (z.length < n) {
            n = z.length;
        }
        this.m_z = new double[n];
        this.m_res = new double[n];
        System.arraycopy(z, z.length - n, this.m_z, 0, n);
        System.arraycopy(res, res.length - n, this.m_res, 0, n);
        this.m_mean = mean;
        this.m_stdev = stdev;
        this.clearresults();
        return this.calc();
    }

    public void setForecastHorizon(int value) {
        this.m_nf = value;
        this.clearresults();
    }

    public void setMeanCorrection(double value) {
        this.m_mean = value;
        this.clearresults();
    }

    public void setModel(IArimaModel value) {
        this.m_model = value;
        this.clearresults();
    }
}

