/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.utilities.Arrays2;

public class Fft {
    private static final double[] CosArray = new double[16];
    private static final double[] SinArray = new double[16];

    public void backTransform(Complex[] data) {
        this.transform(data, true);
    }

    public void transform(Complex[] data) {
        this.transform(data, false);
    }

    private void transform(Complex[] data, boolean back) {
        int n = data.length;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            int q;
            if (j > i) {
                Arrays2.swap(data, i, j);
            }
            for (q = n >> 1; q >= 1 && j >= q; j -= q, q >>= 1) {
            }
            j += q;
        }
        int m = 1;
        int s = 0;
        while (m < n) {
            int tm = m << 1;
            Complex wm = Complex.cart(CosArray[s], back ? -SinArray[s] : SinArray[s]);
            Complex w = Complex.ONE;
            for (int j2 = 0; j2 < m; ++j2) {
                for (int k = j2; k < n; k += tm) {
                    int l = k + m;
                    Complex t = w.times(data[l]);
                    Complex u = data[k];
                    data[k] = u.plus(t);
                    data[l] = u.minus(t);
                }
                w = w.times(wm);
            }
            m = tm;
            ++s;
        }
        if (back) {
            double v = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                data[i] = data[i].times(v);
            }
        }
    }

    static {
        double twopi = Math.PI * 2;
        double n = 2.0;
        for (int i = 0; i < 16; ++i) {
            Fft.CosArray[i] = Math.cos(Math.PI * 2 / n);
            Fft.SinArray[i] = Math.sin(Math.PI * 2 / n);
            n *= 2.0;
        }
    }
}

