/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.DefaultLikelihoodEvaluation;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SparseSystemSolver;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.SsqNumericalDerivatives;
import ec.tstoolkit.utilities.IntList;

public class DifferenceStationaryModelHelper {
    private final int n_;
    private final Matrix J_;
    private final BackFilter Delta_;
    private Matrix B_;
    private Matrix D_;
    private final DataBlock y_;
    private DataBlock dy_;
    private final Matrix X_;
    private final Matrix DX_;
    private boolean valid_ = true;

    public static Matrix missings(IReadDataBlock data) {
        return DifferenceStationaryModelHelper.missings(data, null);
    }

    public static Matrix missings(IReadDataBlock data, int[] inits) {
        int r;
        int n = data.getLength();
        IntList m = new IntList();
        for (int i = 0; i < n; ++i) {
            if (Double.isFinite(data.get(i))) continue;
            m.add(i);
        }
        if (m.isEmpty()) {
            return Matrix.identity(n);
        }
        Matrix J = new Matrix(n - m.size(), n);
        if (inits != null) {
            for (r = 0; r < inits.length; ++r) {
                J.set(r, inits[r], 1.0);
            }
        }
        int mcur = m.get(0);
        int k = 1;
        for (int c = 0; c < n; ++c) {
            if (DifferenceStationaryModelHelper.contains(inits, c)) continue;
            if (mcur != c) {
                J.set(r++, c, 1.0);
                continue;
            }
            mcur = k < m.size() ? m.get(k++) : -1;
        }
        return J;
    }

    private static boolean contains(int[] inits, int c) {
        if (inits == null) {
            return false;
        }
        for (int i = 0; i < inits.length; ++i) {
            if (inits[i] != c) continue;
            return true;
        }
        return false;
    }

    public static Matrix last(int len, int step) {
        int nc = len;
        int nr = nc / step;
        Matrix J = new Matrix(nr, nc);
        int r = 0;
        int c = step - 1;
        while (r < nr) {
            J.set(r, c, 1.0);
            ++r;
            c += step;
        }
        return J;
    }

    public static Matrix first(int len, int step) {
        int nc = len;
        int nr = 1 + (nc - 1) / step;
        Matrix J = new Matrix(nr, nc);
        int r = 0;
        int c = 0;
        while (r < nr) {
            J.set(r, c, 1.0);
            ++r;
            c += step;
        }
        return J;
    }

    public static Matrix aggregation(int len, int nagg) {
        int nc = len;
        int nr = nc / nagg;
        Matrix J = new Matrix(nr, nc);
        int c = 0;
        for (int r = 0; r < nr; ++r) {
            int k = 0;
            while (k < nagg) {
                J.set(r, c, 1.0);
                ++k;
                ++c;
            }
        }
        return J;
    }

    public static int[] searchDefaultInitialValues(IReadDataBlock y, int d) {
        int n = y.getLength();
        for (int i = 0; i < n - d; ++i) {
            int j;
            for (j = 0; j < d && Double.isFinite(y.get(i + j)); ++j) {
            }
            if (j == d) {
                int[] ivals = new int[d];
                for (int k = 0; k < d; ++k) {
                    ivals[k] = i + k;
                }
                return ivals;
            }
            i += j;
        }
        return null;
    }

    public DifferenceStationaryModelHelper(DataBlock y, Matrix X, Matrix transformation, BackFilter difference) {
        this.n_ = transformation.getColumnsCount();
        this.J_ = transformation;
        this.Delta_ = difference;
        this.y_ = y;
        this.X_ = X;
        if (this.X_ != null) {
            int d = this.Delta_.getDegree();
            this.DX_ = new Matrix(this.X_.getRowsCount() - d, this.X_.getColumnsCount());
            for (int i = 0; i < this.X_.getColumnsCount(); ++i) {
                this.Delta_.filter(this.X_.column(i), this.DX_.column(i));
            }
        } else {
            this.DX_ = null;
        }
    }

    public DifferenceStationaryModelHelper(IModelProvider provider) {
        this(provider.getTransformedData(), provider.getDesignMatrix(), provider.getTransformation(), provider.getDifferencing());
    }

    public Matrix getB() {
        if (this.B_ == null) {
            this.calc();
        }
        return this.B_;
    }

    public Matrix getD() {
        if (this.D_ == null) {
            this.calc();
        }
        return this.D_;
    }

    public ConcentratedLikelihood compute(Matrix Vw) {
        if (this.D_ == null) {
            this.calc();
        }
        if (!this.valid_) {
            return null;
        }
        int d = this.Delta_.getDegree();
        if (Vw.getRowsCount() != this.n_ - d) {
            return null;
        }
        int m = this.y_.getLength();
        Matrix Q = SymmetricMatrix.quadraticFormT(Vw, this.B_);
        try {
            SymmetricMatrix.lcholesky(Q);
            ConcentratedLikelihood ll = new ConcentratedLikelihood();
            double ldet = 2.0 * Q.diagonal().sumLog().value;
            DataBlock dy = this.dy_.deepClone();
            LowerTriangularMatrix.rsolve(Q, dy);
            if (this.X_ != null) {
                Matrix BDX = this.B_.times(this.DX_);
                for (int i = 0; i < this.X_.getColumnsCount(); ++i) {
                    LowerTriangularMatrix.rsolve(Q, BDX.column(i));
                }
                Householder qr = new Householder(true);
                qr.setEpsilon(1.0E-12);
                qr.decompose(BDX);
                DataBlock b = new DataBlock(qr.getRank());
                DataBlock res = new DataBlock(BDX.getRowsCount() - qr.getRank());
                qr.leastSquares(dy, b, res);
                Matrix R = qr.getR();
                double ssqerr = res.ssq();
                Matrix bvar = SymmetricMatrix.XXt(UpperTriangularMatrix.inverse(R));
                bvar.mul(ssqerr / (double)dy.getLength());
                ll.set(ssqerr, ldet, dy.getLength());
                ll.setRes(res.getData());
                ll.setB(b.getData(), bvar, qr.getRank());
            } else {
                ll.set(dy.ssq(), ldet, m - d);
                ll.setRes(dy.getData());
            }
            return ll;
        }
        catch (MatrixException err) {
            return null;
        }
    }

    public Matrix computeProjections(Matrix Z, Matrix Vw) {
        int nz = Z == null ? this.n_ : Z.getRowsCount();
        Matrix z = new Matrix(nz, nz + 1);
        int n = this.B_.getColumnsCount();
        int m = this.B_.getRowsCount();
        int d = this.Delta_.getDegree();
        Matrix BV = this.B_.times(Vw);
        Matrix Q = new Matrix(m, m);
        Q.subMatrix().product(BV.subMatrix(), this.B_.subMatrix().transpose());
        SymmetricMatrix.reinforceSymmetry(Q);
        try {
            double sigma;
            SymmetricMatrix.lcholesky(Q);
            DataBlock dy = this.dy_.deepClone();
            LowerTriangularMatrix.rsolve(Q, dy);
            DataBlock b = null;
            Matrix bvar = null;
            Matrix zvar = null;
            if (this.X_ != null) {
                Matrix BDX = this.B_.times(this.DX_);
                LowerTriangularMatrix.rsolve(Q, BDX.subMatrix());
                Householder qr = new Householder(true);
                qr.setEpsilon(1.0E-12);
                qr.decompose(BDX);
                b = new DataBlock(qr.getRank());
                DataBlock res = new DataBlock(BDX.getRowsCount() - qr.getRank());
                qr.leastSquares(dy, b, res);
                Matrix R = qr.getR();
                double ssqerr = res.ssq();
                sigma = ssqerr / (double)dy.getLength();
                bvar = SymmetricMatrix.XXt(UpperTriangularMatrix.inverse(R));
                bvar.mul(sigma);
                for (int i = 0; i < b.getLength(); ++i) {
                    dy.addAY(-b.get(i), BDX.column(i));
                }
            } else {
                sigma = dy.ssq() / (double)dy.getLength();
            }
            try {
                LowerTriangularMatrix.rsolve(Q, BV.subMatrix());
                Matrix T2 = SymmetricMatrix.XtX(BV);
                T2.chs();
                T2.add(Vw);
                Matrix U = new Matrix(this.n_, 2 * this.n_);
                this.delta(U.subMatrix(0, this.n_, 0, this.n_));
                U.subDiagonal(this.n_).set(1.0);
                if (SparseSystemSolver.solve(U)) {
                    zvar = new Matrix(this.n_, this.n_);
                    SymmetricMatrix.quadraticFormT(T2.subMatrix(), U.subMatrix(0, d, this.n_ + d, -1), zvar.subMatrix(0, d, 0, d));
                    SymmetricMatrix.quadraticFormT(T2.subMatrix(), U.subMatrix(d, -1, this.n_ + d, -1), zvar.subMatrix(d, -1, d, -1));
                    zvar.clean(1.0E-6);
                    zvar.mul(sigma);
                }
            }
            catch (MatrixException T2) {
                // empty catch block
            }
            LowerTriangularMatrix.lsolve(Q, dy);
            DataBlock bu = new DataBlock(n);
            bu.product(this.B_.columns(), dy);
            Matrix M = new Matrix(this.n_, this.n_ + 1);
            this.delta(M.subMatrix(0, this.n_, 0, this.n_));
            DataBlock lc = M.column(this.n_);
            lc.range(d, this.n_).product(Vw.rows(), bu);
            lc.range(0, d).copy(this.y_.range(0, d));
            if (b != null) {
                Matrix Xc = new Matrix(d, b.getLength());
                Xc.subMatrix().product(this.J_.subMatrix(0, d, 0, -1), this.X_.subMatrix());
                for (int i = 0; i < b.getLength(); ++i) {
                    lc.range(0, d).addAY(-b.get(i), Xc.column(i));
                }
            }
            if (SparseSystemSolver.solve(M)) {
                if (b != null) {
                    for (int i = 0; i < b.getLength(); ++i) {
                        lc.addAY(b.get(i), this.X_.column(i));
                    }
                }
                if (Z == null) {
                    z.column(0).copy(lc);
                    if (zvar != null) {
                        z.subMatrix(0, this.n_, 1, this.n_ + 1).copy(zvar.subMatrix());
                    }
                } else {
                    for (int i = 0; i < Z.getRowsCount(); ++i) {
                        z.set(i, 0, Z.row(i).dot(lc));
                    }
                }
            }
            return z;
        }
        catch (MatrixException err) {
            return null;
        }
    }

    ConcentratedLikelihood lcompute(IModelProviderEx xprovider, IReadDataBlock p) {
        if (this.D_ == null) {
            this.calc();
        }
        if (!this.valid_) {
            return null;
        }
        int d = this.Delta_.getDegree();
        int m = this.y_.getLength();
        Matrix Q = xprovider.getLCholesky(p, this.B_.clone());
        if (Q == null) {
            return null;
        }
        if (m != this.D_.getColumnsCount()) {
            return null;
        }
        DataBlock dy = this.dy_.deepClone();
        try {
            ConcentratedLikelihood ll = new ConcentratedLikelihood();
            double ldet = 2.0 * Q.diagonal().sumLog().value;
            LowerTriangularMatrix.rsolve(Q, dy);
            if (this.X_ != null) {
                Matrix DX = new Matrix(this.X_.getRowsCount() - d, this.X_.getColumnsCount());
                for (int i = 0; i < this.X_.getColumnsCount(); ++i) {
                    this.Delta_.filter(this.X_.column(i), DX.column(i));
                }
                Matrix BDX = this.B_.times(DX);
                for (int i = 0; i < this.X_.getColumnsCount(); ++i) {
                    LowerTriangularMatrix.rsolve(Q, BDX.column(i));
                }
                Householder qr = new Householder(true);
                qr.setEpsilon(1.0E-12);
                qr.decompose(BDX);
                DataBlock b = new DataBlock(qr.getRank());
                DataBlock res = new DataBlock(BDX.getRowsCount() - qr.getRank());
                qr.leastSquares(dy, b, res);
                Matrix R = qr.getR();
                double ssqerr = res.ssq();
                Matrix bvar = SymmetricMatrix.XXt(UpperTriangularMatrix.inverse(R));
                bvar.mul(ssqerr / (double)dy.getLength());
                ll.set(ssqerr, ldet, dy.getLength());
                ll.setRes(res.getData());
                ll.setB(b.getData(), bvar, qr.getRank());
            } else {
                ll.set(dy.ssq(), ldet, m - d);
                ll.setRes(dy.getData());
            }
            return ll;
        }
        catch (MatrixException err) {
            return null;
        }
    }

    private void delta(SubMatrix m) {
        int d = this.Delta_.getDegree();
        m.extract(0, d, 0, this.n_).copy(this.J_.subMatrix(0, d, 0, this.n_));
        Polynomial p = this.Delta_.getPolynomial();
        SubMatrix Q = m.extract(d, this.n_, 0, this.n_);
        for (int i = 0; i <= d; ++i) {
            Q.subDiagonal(i).set(p.get(d - i));
        }
    }

    private void calc() {
        if (!this.valid_) {
            return;
        }
        int d = this.Delta_.getDegree();
        int m = this.J_.getRowsCount();
        Matrix M = new Matrix(this.n_, this.n_ + m - d);
        this.delta(M.subMatrix(0, this.n_, 0, this.n_).transpose());
        M.subMatrix(0, this.n_, this.n_, this.n_ + m - d).copy(this.J_.subMatrix(d, m, 0, this.n_).transpose());
        if (SparseSystemSolver.solve(M)) {
            this.D_ = new Matrix(m - d, m);
            this.B_ = new Matrix(m - d, this.n_ - d);
            SubMatrix A = this.D_.subMatrix(0, m - d, 0, d);
            A.copy(M.subMatrix(0, d, this.n_, this.n_ + m - d).transpose());
            A.chs();
            this.D_.subDiagonal(d).set(1.0);
            this.B_.subMatrix().copy(M.subMatrix(d, this.n_, this.n_, this.n_ + m - d).transpose());
            this.dy_ = new DataBlock(m - d);
            DataBlock xinit = this.y_.range(0, d);
            for (int i = 0; i < m - d; ++i) {
                this.dy_.set(i, this.y_.get(d + i) + A.row(i).dot(xinit));
            }
        } else {
            this.valid_ = false;
        }
    }

    private void clear() {
        this.B_ = null;
        this.D_ = null;
        this.valid_ = true;
    }

    public static class LikelihoodFunctionInstance<S extends IModelProvider>
    implements IFunctionInstance,
    ISsqFunctionInstance {
        private final DefaultLikelihoodEvaluation<ConcentratedLikelihood> ll_;
        private final DataBlock p_;

        public LikelihoodFunctionInstance(LikelihoodFunction<S> fn, IReadDataBlock p) {
            ConcentratedLikelihood cll;
            S provider = fn.getModelProvider();
            Matrix X = provider.getDesignMatrix();
            DataBlock y = provider.getTransformedData();
            if (fn.isLCompute() && provider instanceof IModelProviderEx) {
                IModelProviderEx xprovider = (IModelProviderEx)provider;
                cll = ((LikelihoodFunction)fn).helper_.lcompute(xprovider, p);
            } else {
                cll = ((LikelihoodFunction)fn).helper_.compute(provider.getStationnaryCovariance(p));
            }
            this.ll_ = new DefaultLikelihoodEvaluation<ConcentratedLikelihood>(cll);
            this.p_ = new DataBlock(p);
        }

        public ConcentratedLikelihood getLikelihood() {
            return this.ll_.getLikelihood();
        }

        @Override
        public IReadDataBlock getParameters() {
            return this.p_;
        }

        @Override
        public double getValue() {
            return this.ll_.getValue();
        }

        @Override
        public double[] getE() {
            return this.ll_.getE();
        }

        @Override
        public double getSsqE() {
            return this.ll_.getSsqValue();
        }
    }

    public static class LikelihoodFunction<S extends IModelProvider>
    implements IFunction,
    ISsqFunction {
        private final S provider_;
        private final IParametersDomain mapping_;
        private final DifferenceStationaryModelHelper helper_;
        private boolean lcompute_ = true;

        public void setLCompute(boolean lc) {
            this.lcompute_ = lc;
        }

        public boolean isLCompute() {
            return this.lcompute_;
        }

        public LikelihoodFunction(S provider, IParametersDomain mapping) {
            this.provider_ = provider;
            this.mapping_ = mapping;
            this.helper_ = new DifferenceStationaryModelHelper((IModelProvider)provider);
        }

        public S getModelProvider() {
            return this.provider_;
        }

        public IParametersDomain getMapping() {
            return this.mapping_;
        }

        public DifferenceStationaryModelHelper getHelper() {
            return this.helper_;
        }

        @Override
        public IFunctionInstance evaluate(IReadDataBlock parameters) {
            return new LikelihoodFunctionInstance(this, parameters);
        }

        @Override
        public IFunctionDerivatives getDerivatives(IFunctionInstance point) {
            return new NumericalDerivatives(this, point, false, true);
        }

        @Override
        public IParametersDomain getDomain() {
            return this.mapping_;
        }

        @Override
        public ISsqFunctionDerivatives getDerivatives(ISsqFunctionInstance point) {
            return new SsqNumericalDerivatives(this, point, false, true);
        }

        @Override
        public ISsqFunctionInstance ssqEvaluate(IReadDataBlock parameters) {
            return new LikelihoodFunctionInstance(this, parameters);
        }
    }

    public static interface IModelProviderEx
    extends IModelProvider {
        public Matrix getLCholesky(IReadDataBlock var1, Matrix var2);
    }

    public static interface IModelProvider {
        public Matrix getStationnaryCovariance(IReadDataBlock var1);

        public BackFilter getDifferencing();

        public Matrix getTransformation();

        public DataBlock getTransformedData();

        public Matrix getDesignMatrix();
    }
}

