/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.IEndPointsProcessor;
import ec.satoolkit.x11.IFiltering;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class DefaultTrendFilteringStrategy
implements IFiltering {
    SymmetricFilter filter;
    IEndPointsProcessor endPointsProcessor;
    private String description_;

    public void setDescription(String desc) {
        this.description_ = desc;
    }

    @Override
    public String getDescription() {
        return this.description_ == null ? "" : this.description_;
    }

    public DefaultTrendFilteringStrategy(SymmetricFilter filter, IEndPointsProcessor endPoints) {
        this.filter = filter;
        this.endPointsProcessor = endPoints;
    }

    public DefaultTrendFilteringStrategy(SymmetricFilter filter, IEndPointsProcessor endPoints, String desc) {
        this.filter = filter;
        this.endPointsProcessor = endPoints;
        this.description_ = desc;
    }

    private TsData compositeProcess(TsData s, TsDomain rdomain) {
        int len = rdomain.getLength();
        DataBlock out = new DataBlock(len);
        int nf = this.filter.getUpperBound();
        DataBlock in = TsDataBlock.select((TsData)s, (TsDomain)rdomain).data;
        this.filter.filter(in, out.drop(nf, nf));
        this.endPointsProcessor.process(in, out);
        return new TsData(rdomain.getStart(), out.getData(), false);
    }

    @Override
    public SymmetricFilter getCentralFilter() {
        return this.filter;
    }

    @Override
    public TsData process(TsData s, TsDomain domain) {
        TsDomain rdomain;
        TsDomain tsDomain = rdomain = domain == null ? s.getDomain() : domain;
        if (this.endPointsProcessor == null) {
            return this.simpleProcess(s, rdomain);
        }
        return this.compositeProcess(s, rdomain);
    }

    private TsData simpleProcess(TsData s, TsDomain rdomain) {
        int n = this.filter.getLength();
        DataBlock out = new DataBlock(rdomain.getLength() - n + 1);
        this.filter.filter(TsDataBlock.select((TsData)s, (TsDomain)rdomain).data, out);
        return new TsData(rdomain.getStart().minus(this.filter.getLowerBound()), out.getData(), false);
    }
}

