% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateResults.R
\name{getBenchmarkResults}
\alias{getBenchmarkResults}
\title{Computing benchmark table with the mean overall results.}
\usage{
getBenchmarkResults(
  errorList,
  nameVec,
  tableTCs,
  errorParam = "zzDevAbsCutoff_Ov",
  cutoffZ = 5,
  catList = c("fractionPathol <= 0.20 & N <= 5000",
    "fractionPathol <= 0.20 & N > 5000", "fractionPathol >  0.20 & N <= 5000",
    "fractionPathol >  0.20 & N > 5000"),
  catLabels = c("lowPlowN", "lowPhighN", "highPlowN", "highPhighN"),
  perfCombination = c("mean", "median", "sum")
)
}
\arguments{
\item{errorList}{(list) containing the the computed errors for the different (indirect) methods/algorithms}

\item{nameVec}{(character) vector specifying the names of the different (indirect) methods/algorithms}

\item{tableTCs}{(data.frame) containing all information about the simulated test sets}

\item{errorParam}{(character) specifying for which error parameter the data frame should be generated}

\item{cutoffZ}{(integer) specifying if and if so which cutoff for the absolute z-score deviation should be used to 
classify results as implausible and exclude them from the overall benchmark score (default: 5)}

\item{catList}{(character) vector containing the categories to split the dataset}

\item{catLabels}{(character) vector containing the labels that will be used for the categories}

\item{perfCombination}{(character) specifying which measure should be used to compute the overall benchmark score; 
choose from "mean" (default), "median", or "sum"}
}
\value{
(data frame) containing the computed benchmark results
}
\description{
Computing benchmark table with the mean overall results.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
