% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateTestSets.R
\name{runTC_usingRscript}
\alias{runTC_usingRscript}
\title{Function for running test sets per algorithm per marker with calling Rscript for each test set}
\usage{
runTC_usingRscript(
  biomarker = NULL,
  algoName = "myOwnAlgo",
  algoFunction = "estimateModel",
  sourceFiles = NULL,
  libs = NULL,
  params = NULL,
  decimals = FALSE,
  ris = FALSE,
  RIperc = c(0.025, 0.975),
  tableTCs = NULL,
  outputDir = NULL,
  inputDir = NULL,
  timeLimit = 14400,
  subsetDef = "all",
  verbose = TRUE,
  showWarnings = FALSE,
  ...
)
}
\arguments{
\item{biomarker}{(character) specifying the biomarker for which the algorithm should calculate RIs}

\item{algoName}{(character) specifying the algorithm that should be called}

\item{algoFunction}{(character) specifying the name of the function needed for estimating RIs}

\item{sourceFiles}{(list) containing all source files needed for executing the algorithm}

\item{libs}{(list) containing all libraries needed for executing the algorithm}

\item{params}{(list) with additional parameters needed for calling algoFunction}

\item{decimals}{(logical) indicating whether the algorithm needs the number of decimal places (TRUE) or not (FALSE, default)}

\item{ris}{(logical) indicating whether only percentiles and no model is estimated}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval}

\item{tableTCs}{(data.frame) with the information about the simulated test sets}

\item{outputDir}{(character) specifying the outputDir: Results will be stored in outputDir/Results/algo/biomarker}

\item{inputDir}{(character) specifying the inputDir: Data files should be stored in inputDir/Data/biomarker}

\item{timeLimit}{(integer) specifying the maximum amount of time in seconds allowed to execute one single estimation (default: 14400 sec (4h))}

\item{subsetDef}{(character) describing the specified subset of all test sets the algorithm is applied to, used for naming the progress file}

\item{verbose}{(logical) indictaing if the progress counter should be shown (default: TRUE)}

\item{showWarnings}{(logical) indicating whether warnings from the call to the indirect method/algorithm should be shown (default: FALSE)}

\item{...}{additional arguments to be passed to the method}
}
\value{
(data frame) containing information about the test sets where the algorithm terminated the R session or failed to report a result
}
\description{
Function for running test sets per algorithm per marker with calling Rscript for each test set
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
