% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\encoding{UTF-8}
\name{geometry}
\alias{geometry}
\title{Calculates geometry-based parameters of RIA image}
\usage{
geometry(RIA_data_in, xy_dim = RIA_data_in$log$orig_xy_dim,
  z_dim = RIA_data_in$log$orig_z_dim,
  all_vol = RIA_data_in$log$orig_vol_mm,
  all_surf = RIA_data_in$log$orig_surf_mm, calc_dist = FALSE,
  calc_sub = TRUE, use_type = "single", use_orig = FALSE,
  use_slot = NULL, save_name = NULL, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}.}

\item{xy_dim}{numeric, in plane resolution.}

\item{z_dim}{numeric, cross plane resolution.}

\item{all_vol}{numeric, volume of whole lesion.}

\item{all_surf}{numeric, surface of whole lesion.}

\item{calc_dist}{logical, whether to calculate distances, may take very long.}

\item{calc_sub}{logical, indicating whether to calculate metrics for all different values
present in the image. This can be useful for calculating metrics of subcomponents for
a discretized image. If FALSE, then all voxels are treated equally and the results will
be based on the whole image.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"discretized"}
takes all datasets in the \emph{RIA_image$discretized} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
if the desired dataset is in \emph{RIA_image$discretized$ep_4}, then \emph{use_slot} should be
\emph{discretized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$stat_geometry} to save results to.
If left empty, then it will be automatically determined by RIA.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing geometry calculations.
}
\description{
Calculates geometry-based parameters of original or subcomponents of
an image after discretization.
By default the \emph{$modif} image will be used to calculate statistics. If \emph{use_slot}
is given, then the data present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{stat_geometry} slot. The name of the subslot is determined
by the supplied string in \emph{save_name}, or is automatically generated by RIA.
}
\examples{
\dontrun{
#Calculate geometry-based parameters on original image
RIA_image <- geometry(RIA_image, use_orig = TRUE, calc_sub = FALSE)

#Discretize loaded image and then calculate geometry-based statistics on subcomponents
RIA_image <- discretize(RIA_image, bins_in = c(4,8), equal_prob = TRUE, use_orig = TRUE)
RIA_image <- geometry(RIA_image, use_orig = FALSE, calc_sub = TRUE)

#Use use_slot parameter to set which image to use
RIA_image <- geometry(RIA_image, use_orig = FALSE, calc_sub = TRUE, use_slot = "discretized$ep_4")

#Batch calculation of geometry-based statistics on all discretized images and subcomponents
RIA_image <- geometry(RIA_image, use_type = "discretized", calc_sub = TRUE)
}


}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
