/**************************************************************
 *** RHmm version 1.4.3                                     
 ***                                                         
 *** File: Main.cpp 
 ***                                                         
 *** Author: Ollivier TARAMASCO <Ollivier.Taramasco@imag.fr> 
 *** Author: Sebastian BAUER <sebastian.bauer@charite.de>
 *** Date: 2010/12/01                                     
 ***                                                         
 **************************************************************/

#ifndef _RDLL_
#include <iostream>
#include <fstream>
#include "Hmm.h"
#include "cInParam.h"
#include "cBaumWelchInParam.h"
#include "cBaumWelch.h"
#include "AllDistributions.h"
#include "cHmm.h"
#include "cHmmFit.h"
#include "cViterbi.h"
#include "RHmm.h"
using namespace std;

#define FIC_NAME  "Norm.txt" /*"Geyser.txt" "data_mixture.txt" "DISCRETEb.txt" "DISCRETE.txt"   "Geyser.txt" "SimulMultiMixt.txt"*/
#define DIM_OBS 1
#define NB_SAMPLE 1
int main(void)
{
ifstream myFile ;
cOTVector* myRt = new cOTVector[NB_SAMPLE] ;
register uint n = 0 ;
double myAux ;
	myFile.open(FIC_NAME) ;
	while (myFile)
	{	myFile >> myAux ;		
		n++ ;
	}
	n = (n-1)/(DIM_OBS*NB_SAMPLE) ;
	myFile.close() ;
	for (register uint j = 0 ; j < NB_SAMPLE ; j++)
		myRt[j].ReAlloc(DIM_OBS*n) ;
	std::fstream myFile1(FIC_NAME) ;
	for (register uint i = 0 ; i < NB_SAMPLE ; i++)
		for (register uint j = 0 ; j < n  ; j++)
			for (register uint k = 0 ; k < DIM_OBS ; k++)
				myFile1 >> myRt[i][j + k*n]  ;
	
//	myRt[1] = myRt[0] ;
	myFile1.close() ;

/*cOTVector* myRt1 = new cOTVector[1] ;
	myRt1[0].ReAlloc(n) ;
	for (register uint i = 0 ; i < n ; i++)
		myRt1[0][i] = myRt[0][i(*+n*)] - 1;
*/

//cHmm MyHMM(eNormalDistr, 2) ;
uint myDimObs = DIM_OBS ;

cBaumWelchInParam myParam=cBaumWelchInParam(1, myDimObs, myRt, eNormalDistr, 2) ;
//cBaumWelchInParam myParam=cBaumWelchInParam(1, myDimObs, myRt1, eDiscreteDistr, 3, 0, 10) ;
//cBaumWelchInParam myParam=cBaumWelchInParam(NB_SAMPLE, myDimObs, myRt, eMixtUniNormalDistr, 2, 3) ;
//cBaumWelchInParam myParam=cBaumWelchInParam(NB_SAMPLE, myDimObs, myRt, eMultiNormalDistr, 3) ;

/*cHmm myHMM(eDiscreteDistr, 2) ;
	myHMM.mInitProba[0] = myHMM.mInitProba[1] = 0.5L ;
	myHMM.mTransMat[0][0]=0.95L ;
	myHMM.mTransMat[0][1]=0.05L ;
	myHMM.mTransMat[1][0]=0.10L ;
	myHMM.mTransMat[1][1]=0.90L ;

cDiscrete myDistrParam(2, 6) ;
	for (register int j = 0 ; j < 6 ; j++)
	{	myDistrParam.mProba[0][j] = 1.0L/6.0L ;
		myDistrParam.mProba[1][j] = 1.0L/10.0L ;
	}
	myDistrParam.mProba[1][5] = 1.0L/2.0L ;
	myHMM.mDistrParam = &myDistrParam ;
	
*/
	myParam.Print() ;
	myParam.mVerbose = 2 ;
	myParam.mNInitIter = 5 ;
	myParam.mNMaxIterInit = 5 ;
	myParam.mNMaxIter = 500 ;


cHmmFit myHMMFit(myParam) ;
	myHMMFit.BaumWelchAlgoInit(myParam) ;
	myHMMFit.BaumWelchAlgo(myParam) ;
	myHMMFit.Print() ;
/*
cOTMatrix*	myProbaCond = new cOTMatrix[myParam.mNSample] ; 
	
 	for (register uint n = 0 ; n < myParam.mNSample ; n++)
	{	
	uint mySize = myParam.mY[n].mSize/myParam.mDimObs ;
		myProbaCond[n].ReAlloc(myParam.mNClass, mySize) ;
	}
	myHMMFit.mDistrParam->ComputeCondProba(myParam.mY, myParam.mNSample, myProbaCond) ;
	myHMMFit.ForwardBackward(myProbaCond, myHMMFit) ;
	cout << *(myHMMFit.mRho) ;


cViterbi myViterbi(myParam) ;
	myViterbi.ViterbiPath(myParam, myHMMFit) ;
//	myViterbi.ViterbiPath(myParam, myHMM) ;
	for (register uint n = 0 ; n < myParam.mNSample ; n++)
		for (register uint i = 0 ; i < myParam.mY[n].mSize ; i++)
			std::cout << myViterbi.mSeq[n][i] << std::endl ;
			source("C:/Users/taram/Documents/R/RHMM DEBUG/debug.R")
*/
/*
cOTVector myGrad ;
	myHMMFit.ComputeGradient(myParam, myGrad, 1e-2) ;
	std::cout << "Gradient : \n" ;
	std::cout << myGrad ;

cOTMatrix myHess	;
	myHMMFit.ComputeHessian(myParam, myHess,1e-5) ;
	std::cout << "Hessian : \n" ;
	std::cout << myHess ;

cOTMatrix	myI,
			myJ,
			myInvJ,
			myCov	;

	myI = myGrad*transpose(myGrad) ;
	myJ = myHess ;
	myJ /= -(double)n ;
	myInvJ = inv(myJ) ;
	myCov = myInvJ ;
	myCov /= (double)n ;
	myCov = myInvJ * myI ;
	myCov *= myInvJ ;
	std::cout << "Cov : \n" ;
	std::cout << myCov ;

*/
	return 0 ;
} 

/*
 FILE data_mixture.txt
-----------------------------------------
2.93024
2.587127
-3.275055
-2.719738
1.795036
-0.240871
0.8613079
0.4960428
5.095914
2.452755
2.965042
1.402603
2.383597
7.816888
-2.022861
4.936794
5.54443
0.9944021
2.488001
4.26077
-2.159305
-3.534865
-1.711918
-4.371556
-5.583346
-1.179488
1.947405
4.446895
-0.5049458
0.8635857
0.966578
-2.800192
1.433107
3.944222
-2.968383
3.344331
2.685027
6.231044
-4.57968
-1.340801
-2.898079
3.372161
2.19085
3.602694
0.4705131
0.8910234
2.94513
2.818134
2.850448
1.608191
2.530541
5.846393
1.084363
7.349594
1.828069
0.7568079
0.9127634999999999
2.362131
1.33465
0.5539525
-2.514981
1.477378
3.94269
-0.09044663999999999
-0.9424110999999999
3.865053
2.798947
0.1459337
1.389666
1.464446
5.011162
-2.964077
-2.116558
3.271823
3.835747
3.875648
-3.513572
-1.276623
3.745517
2.858582
3.913473
3.93764
-3.845127
0.2554359
2.903012
-4.336472
0.2065408
-4.670483
-1.302328
1.142511
-2.556197
1.035648
-0.01507606
-0.9069014
1.229201
-1.606405
-2.955063
-1.61691
6.404251
1.107658
-3.609881
-3.11991
-3.101295
-2.998864
-1.837603
3.832873
0.3436509
1.358984
-3.660698
1.044858
5.126386
0.8770656999999999
3.49334
1.881896
-2.978435
-2.003899
-1.723408
0.9000968
-2.788153
-1.1565
-0.2312353
-3.473245
-2.199173
-0.2034954
1.841593
0.4935512
0.04247411
-1.234834
0.8150482999999999
3.766661
2.174393
4.002996
2.463356
-2.021309
-3.587376
1.638233
5.127805
1.756071
0.7482187
5.141234
-3.789373
3.177234
-2.967984
-1.146569
-4.187994
3.877111
-1.976453
1.128911
3.536002
5.19282
0.4092828
-4.722578
1.267015
4.473125
1.51067
2.39587
2.766917
2.71887
0.8227835
0.5448739
4.18166
0.4373095
-3.894489
3.674324
-1.173342
4.227528
2.568001
0.8590120999999999
-4.03606
-4.925849
-1.064571
2.211834
3.219022
1.787701
-0.9481612
2.191388
2.36115
-3.951395
-1.718093
0.3765934
1.513132
8.597020000000001
1.553119
6.674751
2.687037
3.547899
-2.655158
-3.569438
1.387282
-4.547074
-2.273054
-1.807411
2.39622
3.434503
2.04539
-1.120899
-2.522876
2.266581
0.163651
6.564834
-3.125894
3.911587
-0.6360178
3.051424
-3.69816
-3.413939
-2.227191
0.04577044
2.946444
1.136251
0.3849702
1.537029
-2.141061
3.239122
6.567585
2.290244
2.826445
1.345531
1.958277
5.649073
0.9146937000000001
3.508308
-0.7199109
3.619879
2.281361
-1.708813
1.234004
2.369581
2.870661
5.613611
2.612533
0.128885
-4.694349
1.072437
2.810387
-5.184314
-2.276374
-1.26913
3.656757
2.215351
0.1585255
4.056011
0.176917
2.156027
2.448672
1.345682
1.815613
-1.200599
5.887995
2.444628
1.276669
1.830147
4.441154
1.661701
2.60061
-1.827522
-0.02067783
2.920396
-1.517875
-4.553307
-0.2544085
1.854279
2.767143
1.567063
6.626782
5.217597
2.297867
3.430262
4.198314
4.534334
1.764756
3.332937
3.35389
1.891611
3.966438
-1.372913
-1.411212
3.090347
0.3983163
2.565654
-1.276886
2.262988
2.945593
2.969154
-1.653468
-0.02558632
-3.146667
0.7850566
-0.4456083
-0.729102
-2.111621
-3.71061
2.760233
0.0640617
2.919504
1.971577
-3.936999
2.810436
1.916472
0.2954587
0.6413797
2.140211
1.336942
5.476497
5.13469
-3.630952
-1.188396
-3.14519
3.685825
2.929678
3.15396
4.451066
4.317162
3.57221
-1.642497
5.174613
4.342375
-2.076686
3.289937
-1.514222
-5.137022
-1.07097
-3.691116
1.505013
-2.348408
4.910313
1.374655
1.534447
2.973439
4.472555
6.239633
2.160037
4.449142
3.491066
0.9894463
1.866565
2.090924
0.1831156
-2.160455
-2.074777
-1.073258
1.283287
3.837802
4.644743
-5.380949
-1.324336
-3.994707
3.250002
3.839847
1.242777
2.885011
4.077094
5.165735
1.202498
2.370301
1.864528
1.273934
-3.113244
-1.875141
-2.763477
-3.36119
-2.282868
1.393792
4.909106
-2.50367
-2.934199
-2.745474
-2.456587
-3.537047
-2.761545
1.424543
4.451673
4.706982
-2.402215
0.1376632
1.282322
0.3907527
2.329466
6.372707
-1.596786
-3.393752
4.070075
2.476226
1.070558
3.624616
3.7888
5.746984
-2.370179
5.469459
-2.200485
-2.104365
1.455677
1.916791
4.532996
0.6787644
-0.7196271
0.7175218
3.640049
0.6111251
-2.063803
4.632773
4.642406
4.442337
5.285913
3.65021
1.800592
2.668773
-0.7136154
2.552548
5.586033
1.436274
3.427616
6.350853
1.259202
4.506434
-4.602552
0.9781233
-0.3621882
-3.724326
3.337864
0.3781168
4.204853
3.309166
-1.430391
0.3032594
1.939269
-1.615339
-2.044949
4.588539
2.630866
3.359957
0.2983989
2.23508
-2.096724
-3.140341
-4.11782
4.430604
5.560664
2.975323
4.192928
-2.495847
4.425596
4.99205
4.594708
4.939918
5.645194
0.2110866
3.322332
3.629901
3.794343
4.360848
-0.989969
-4.057899
3.244917
5.168944
-2.053234
-0.524802
1.043014
2.896124
2.090646
4.305641
1.288386
2.197151
2.627474
1.16508
0.5945984
0.9101832
1.473005
0.2513954
1.651132
4.968104
0.3887616
1.83528
3.058698
1.274602
-2.465803
-1.771346
-1.158481
-4.712967
1.872821
-0.0519189
-2.526495
4.468693
0.4915306
-3.710901
-2.59455
2.073145
-0.6712276
1.18958
0.3509166
1.900926
3.507519
2.111285
5.568726
6.131149
4.451653
4.197821
-2.387727
-0.1395648
-3.184011
-2.158463
4.085324
-0.2935152
1.479509
5.685612
1.12942
-3.489465
-3.47612
-2.173792
0.6919275
-2.101311
-1.433362
-1.745317
-0.3955348
2.308129
1.129549
4.20977
-4.102287
-4.029424
1.375574
1.071856
5.752774
5.954665
4.253465
2.694367
3.834477
3.006043
1.390724
0.958104
2.105148
0.0964863
-3.009789
-3.200579
-2.777869
3.227874
5.058581
2.876872
1.982836
1.830675
7.62462
0.7490523
1.039629
3.135767
-3.541376
-1.950973
0.5005134
3.988251
2.858471
2.72105
3.911644
0.8464086
1.600031
1.824648
1.891536
2.139589
0.5302601
-2.628828
-2.4456
-3.559064
-0.3498973
2.531613
4.132555
1.531416
4.018863
2.998542
2.158973
-0.4840599
-3.234282
0.2475394
0.783397
-3.027556
0.8760275
2.514844
2.343009
4.021622
1.651767
-0.4127959
2.280215
4.159703
2.498838
-0.6245607
-3.53472
-1.369019
-1.184131
1.199203
2.105681
2.143439
3.827992
0.1235159
1.608793
-2.906686
1.118178
0.928795
-1.10127
0.6730853999999999
3.550057
1.205162
2.415504
2.699524
0.5043863
-2.577122
-3.684018
-1.905021
-2.524637
-2.992939
-2.047233
-0.8084017999999999
0.01117771
0.8117674
-0.2739274
4.13051
1.35131
1.651679
3.817228
-1.224305
1.170279
-2.553105
0.2741911
2.598296
2.638645
-3.139045
-2.006917
3.190678
-0.2071653
2.960866
5.865767
-3.544891
3.212734
-1.874544
-2.454196
4.756197
5.734446
3.130571
0.591803
1.119674
3.08653
1.799227
1.793476
4.274031
-0.9361887
3.056527
-3.600133
6.081499
1.658533
0.7673805
-2.713275
-1.559667
0.03792901
-0.9101433
-2.701377
-1.321664
2.148023
0.7154384
3.68551
1.48929
1.701634
0.3248328
1.163578
1.953547
0.3775209
-2.923965
-2.530724
-0.6617669
-2.978568
0.2979653
6.612183
3.17185
-3.095553
5.223894
0.4818704
-3.108171
-2.662749
-0.5453893
-0.5557603
-3.056542
2.277592
4.467167
5.323316
3.805414
3.083917
-2.229706
-2.157003
-0.5385699
-1.573147
-0.967273
-1.39179
-2.90887
-2.554731
2.905595
-3.401008
-0.8979266
1.581735
3.884938
4.265616
4.929955
1.67504
1.474606
-1.724305
-1.94683
2.955718
1.388301
5.730965
4.12652
0.152336
4.740704
-2.518787
-1.784598
-4.601964
-0.4727062
-2.619008
-2.196765
-2.08513
-5.07687
1.918788
3.297733
0.5729172
4.06603
1.876981
2.076824
-0.5651674
3.450221
1.2118
-1.013863
4.434833
-4.784286
-2.114505
0.5154185
-0.9979729000000001
1.94028
-3.436233
5.760349
0.9186095
0.1051466
-1.406721
0.1727584
2.081354
1.909339
1.61274
1.313333
1.89794
0.6599261
-1.095616
0.3302734
6.252126
-0.8870262
0.1857008
4.930652
1.644796
0.81635
1.570282
6.132099
-2.513757
3.591938
-0.5145448
-1.230712
2.323534
3.311498
2.471211
3.109305
-0.02267508
2.98686
4.742398
6.20436
0.2658622
2.605785
4.013738
-3.123979
-0.8943376
0.2048732
1.057943
1.562415
1.197325
-0.9109452
6.681668
1.12176
-0.30976
-1.143417
-1.001322
8.058624999999999
-1.110973
1.379224
1.664013
-0.1745795
1.506373
-1.753649
2.081764
-2.405943
5.036561
1.870008
4.133212
4.646048
-1.155387
-3.916509
-3.812376
0.7115286
-1.28645
-3.240611
5.418713
5.082362
-2.469971
4.737609
7.31011
1.347917
2.707838
3.072518
1.131398
1.355982
2.085286
3.969195
3.545031
-3.727942
-4.246196
-3.655812
-2.205083
-5.639096
0.8108072
-3.293094
-1.373357
0.538438
-3.164891
3.307513
-3.434189
-4.246057
3.433008
3.403133
1.137172
4.12351
-1.188085
0.1732232
0.6888322
-2.940917
4.263344
-0.2731678
-0.7785983
2.336456
3.129219
6.375355
0.7432866
-0.5470275999999999
4.34426
-2.858385
-4.753614
-0.4383143
-3.066512
0.05405682
3.823748
0.1786013
8.53138
3.131269
3.652518
1.656075
4.383397
1.654309
3.038811
2.377136
5.459805
-1.259611
0.8438213
2.641184
1.126872
-0.6965170000000001
-3.349917
1.024998
-3.122979
2.137006
-0.2347946
-0.2570328
-3.211429
4.274095
0.8957270000000001
0.7397595
2.434354
-3.236178
3.967132
2.396373
4.835597
3.321257
2.744391
2.968802
-2.382007
-3.681315
-0.1833291
2.171894
-1.926667
4.776053
1.413017
0.2147773
2.868294
4.457503
1.203963
-4.532967
3.791922
-3.974502
-3.167208
4.881281
4.339574
-1.849824
5.738727
1.542225
0.7490816
-2.734677
-0.9721452
4.491417
4.380946
2.365058
3.058787
3.723747
0.8407355
-1.134743
1.322559
0.3526926
3.119984
8.219136000000001
3.376359
3.081882
7.00403
3.775768
1.453243
0.4333728
-0.3572325
3.320354
1.053731
2.888281
2.444407
5.21023
0.3419899
3.531226
-0.3546522
0.2658038
3.294484
2.488405
5.086001
0.2142342
3.501204
-2.486175
0.6134883
-0.3400588
6.157839
5.210762
2.331214
0.2513138
-3.002458
-1.309329
0.1634065
-2.352574
0.3628532
-3.853823
-1.659295
-2.730096
-0.0004143169
3.182102
2.811527
-3.319619
1.137736
3.035815
3.244917
0.009979122
-0.0273538
3.703777
-1.773149
3.428325
1.82297
3.555363
-0.02414928
-0.2960717
-0.6389175
-0.249027
1.951569
-0.3630284
6.539617
1.356516
2.974331
2.177169
1.221101
5.949947
1.653434
7.719859
2.677924
-4.594629
-1.585817
0.4814976
3.762294
2.250181
0.2042558
6.248694
1.681041
6.051792
4.398702
2.264478
0.8976170999999999
0.7736223
2.423589
0.550951
4.169242
-0.03261197
-4.682984
3.041507
1.352657
-4.294764
-3.284924
-----------------------------
*/

/*
 FILE Discrete.txt
 ----------------------------
6
6
6
6
6
6
6
6
1
------------------------------
*/

/*
 FILE Discreteb.txt
 -----------------------------
3
8
7
7
7
7
4
6
8
7
7
7
7
7
7
8
8
6
4
9
6
5
7
7
6
7
7
7
4
4
6
6
4
6
6
7
6
7
7
7
3
5
8
9
8
8
8
8
8
8
4
9
7
8
3
7
8
5
7
7
4
6
7
6
4
5
3
4
6
7
4
6
6
6
6
7
6
6
4
3
4
3
3
4
7
4
6
3
4
4
6
6
7
4
6
7
7
6
7
7
7
8
7
8
7
7
5
7
7
7
8
8
4
8
9
4
3
4
3
7
7
9
7
9
7
7
8
4
7
7
8
7
7
4
7
8
7
8
8
5
3
3
4
3
6
3
6
3
3
3
3
3
3
3
2
3
5
2
4
8
7
7
5
8
8
9
8
8
8
8
8
8
7
7
8
6
8
7
8
7
7
8
7
10
9
3
8
7
7
5
7
8
8
8
8
3
7
8
8
8
7
7
8
7
8
8
7
8
7
7
6
7
8
7
8
8
7
8
7
7
7
6
6
7
8
7
7
7
8
4
4
6
6
6
6
4
4
7
8
6
7
5
3
7
5
7
6
6
3
4
4
7
4
6
4
7
3
3
7
6
6
6
5
5
5
3
3
6
6
5
3
3
4
4
4
6
7
7
6
5
5
4
7
4
7
4
6
4
8
7
4
3
8
8
8
7
8
7
8
8
8
9
9
4
7
8
6
5
6
7
7
5
4
4
3
6
7
4
3
4
3
3
3
4
6
7
4
4
6
5
4
7
6
6
7
6
6
5
7
6
8
7
7
7
7
7
8
9
7
3
7
6
8
8
9
8
5
6
3
4
6
4
4
4
4
4
7
5
7
6
8
6
4
7
6
4
6
4
6
7
7
4
3
6
5
4
7
6
5
7
6
6
6
4
5
7
4
6
7
4
3
4
4
4
6
9
8
8
7
7
4
4
7
3
8
8
8
7
7
7
3
7
7
8
7
4
8
8
7
7
7
8
7
8
8
8
7
4
7
4
4
4
6
3
3
3
7
3
4
3
7
8
8
8
8
3
3
5
4
4
6
5
7
7
3
6
7
7
7
7
8
8
8
8
7
7
7
8
8
8
7
8
9
4
6
8
7
9
8
7
4
9
5
5
5
7
7
7
6
7
8
8
4
5
8
3
8
8
7
8
9
4
8
8
7
6
7
7
7
7
8
8
4
8
7
7
8
8
7
4
7
7
3
3
3
6
3
4
3
6
4
3
6
4
7
7
7
4
8
7
5
7
7
4
7
10
8
7
8
8
7
8
7
3
8
3
8
8
8
8
8
7
7
3
3
3
4
3
6
5
6
7
4
7
6
7
6
5
7
5
3
6
6
6
6
6
7
6
4
7
6
7
5
7
4
3
6
3
4
7
7
7
6
6
7
3
6
6
6
6
5
4
4
2
3
3
7
6
6
6
5
3
7
7
3
6
4
3
3
4
5
3
7
3
3
3
2
3
9
3
7
3
4
7
8
7
8
8
10
8
7
7
9
7
8
9
3
8
3
7
8
7
7
8
7
7
7
7
5
9
7
7
9
8
9
4
8
7
8
8
8
7
6
8
7
7
7
8
8
4
3
3
3
4
2
4
4
5
6
3
3
3
4
4
6
6
3
3
3
6
6
4
3
3
6
4
4
7
7
4
7
3
3
5
7
5
7
8
4
3
4
8
3
6
8
8
8
8
7
7
7
5
8
6
7
4
6
8
6
3
5
7
7
7
7
4
7
6
7
3
3
3
6
6
6
6
3
3
3
8
8
7
6
8
7
7
7
7
9
8
4
7
7
7
7
7
7
4
4
9
7
8
3
4
8
4
7
9
4
7
8
7
4
6
3
8
7
7
6
7
7
6
6
5
7
6
7
4
6
3
3
4
4
5
6
7
4
4
4
6
6
6
3
3
3
7
7
7
4
3
3
5
3
7
7
7
7
6
6
7
4
6
5
6
4
4
7
4
6
6
4
5
5
6
6
6
4
5
6
5
3
4
3
3
3
3
4
3
6
3
8
7
4
7
7
7
7
7
6
7
5
7
4
4
6
5
8
8
7
9
7
8
8
8
8
7
8
8
4
4
7
7
3
4
8
4
8
8
7
8
7
8
7
4
8
7
5
7
3
7
6
6
5
3
3
3
4
3
3
3
3
6
7
8
8
8
7
8
2
7
4
6
3
3
3
5
4
3
3
3
3
4
6
3
6
5
6
7
7
6
3
3
4
7
7
6
7
3
4
4
3
3
3
3
3
3
5
3
8
7
3
3
3
3
3
3
7
7
6
4
6
3
2
3
3
7
3
4
3
6
7
6
4
6
7
3
3
7
4
7
6
4
7
4
5
6
6
4
7
7
5
4
6
5
3
2
4
6
6
5
7
4
7
5
6
7
4
4
7
7
7
6
5
4
6
6
4
2
6
7
6
4
7
6
6
5
7
7
7
7
7
7
7
9
7
7
7
7
7
6
5
4
4
3
6
7
6
6
4
3
3
3
3
3
3
3
3
4
6
3
4
6
5
6
7
7
8
7
7
7
8
6
6
4
7
3
3
3
4
3
3
3
6
7
4
4
3
6
3
3
3
8
8
10
7
6
6
4
8
8
8
7
8
8
8
4
7
8
5
7
6
3
9
8
8
7
7
8
7
7
8
8
7
8
4
8
7
7
7
8
8
6
6
7
7
6
3
3
4
3
4
3
6
7
4
5
6
5
3
3
5
6
6
6
6
6
4
8
8
7
4
8
4
8
7
8
7
7
7
4
4
3
4
3
6
6
6
3
5
6
2
4
6
7
5
6
6
7
6
4
3
4
7
7
6
4
5
5
6
7
6
3
4
5
6
6
5
6
4
6
6
4
5
6
3
3
4
4
3
3
3
3
4
3
3
3
4
5
9
9
8
8
8
7
7
8
7
7
10
5
7
4
8
8
8
6
7
8
3
8
8
8
7
7
4
8
8
9
7
7
3
3
3
4
3
4
6
5
6
4
6
7
4
4
6
5
6
6
7
8
5
8
4
7
8
3
7
7
3
3
4
6
4
3
3
4
4
4
3
4
4
6
7
8
8
8
8
8
8
4
8
9
8
7
6
8
6
7
8
8
4
6
4
5
7
7
3
3
1
5
2
4
3
3
3
4
7
7
8
8
8
3
7
7
7
7
7
8
7
4
7
7
4
8
8
4
8
8
8
7
7
3
8
7
8
7
8
7
6
6
6
6
7
6
5
3
4
2
3
2
3
4
3
3
4
4
4
4
8
7
7
3
8
7
9
7
6
7
6
6
6
3
3
3
7
3
3
7
6
5
7
5
3
3
4
4
4
3
3
3
3
3
4
3
3
3
3
3
4
3
3
4
6
4
7
7
5
6
7
7
6
6
4
5
4
7
5
3
7
8
8
8
8
8
8
7
4
8
8
4
8
8
7
7
8
8
4
4
8
4
8
7
7
5
4
6
6
8
4
6
6
4
5
3
6
6
6
6
6
5
7
7
3
3
3
3
3
5
3
3
3
3
3
3
4
4
7
7
3
3
3
7
4
3
4
2
5
3
3
6
3
6
6
6
6
6
6
6
7
8
6
7
7
7
8
7
9
8
7
8
7
8
8
8
8
3
7
3
3
3
3
3
4
3
2
4
3
3
4
5
9
8
7
8
7
7
7
7
6
4
7
8
3
3
4
4
3
3
6
4
6
7
5
6
7
7
7
4
6
7
6
7
7
6
6
6
6
6
6
7
6
7
4
3
6
4
3
6
4
7
7
7
8
8
8
8
3
8
4
8
7
5
8
7
8
7
8
5
9
8
8
8
6
5
7
7
8
7
8
8
8
7
6
4
3
3
4
3
3
3
4
3
4
3
3
6
7
8
6
7
7
8
8
7
7
3
5
6
6
6
7
7
2
7
4
6
7
4
5
7
7
6
4
5
7
6
5
4
3
3
5
4
5
8
7
6
7
4
4
3
4
3
3
5
7
6
5
6
7
6
3
3
3
3
6
7
3
7
4
4
6
3
4
3
7
5
5
7
5
3
3
3
7
7
7
8
7
6
3
7
5
8
6
6
8
6
6
4
3
3
3
2
4
3
6
6
8
4
3
5
4
4
4
3
4
4
7
4
3
6
4
6
5
6
6
4
3
3
3
4
5
6
8
3
4
6
6
6
4
7
7
7
3
7
6
3
4
2
3
4
8
5
8
7
7
8
3
7
8
6
7
7
5
2
7
8
7
7
8
7
7
8
3
4
3
3
3
4
3
4
2
6
7
2
6
8
4
3
7
7
3
3
3
8
3
5
4
6
4
3
3
3
7
6
9
8
5
7
6
7
8
5
7
8
3
3
3
4
3
2
4
4
4
3
4
6
4
3
3
3
5
7
7
6
4
4
4
3
6
7
6
3
3
3
6
7
8
6
7
7
7
8
7
7
4
7
7
6
7
6
8
8
8
7
8
8
7
6
4
7
6
4
4
3
4
6
6
8
6
6
6
6
9
4
9
7
4
8
8
3
9
6
8
7
8
9
6
7
7
7
----------------------------
*/
/*
FILE: Geyser.txt
----------------------------
80.0    4.0166667
71.0    2.15
57.0    4
80.0    4
75.0    4
77.0    2
60.0    4.3833333
86.0    4.2833333
77.0    2.0333333
56.0    4.8333333
81.0    1.8333333
50.0    5.45
89.0    1.6166667
54.0    4.8666667
90.0    4.3833333
73.0    1.7666667
60.0    4.6666667
83.0    2
65.0    4.7333333
82.0    4.2166667
84.0    1.9
54.0    4.9666667
85.0    2
58.0    4
79.0    2
57.0    4
88.0    2.8333333
68.0    4.5
76.0    4.0666667
78.0    3.7166667
74.0    3.5166667
85.0    4.4666667
75.0    2.2166667
65.0    4.8833333
76.0    2.6
58.0    4.15
91.0    2.2
50.0    4.7666667
87.0    1.8333333
48.0    4.6
93.0    2.2666667
54.0    4.1333333
86.0    2
53.0    4
78.0    2
52.0    4
83.0    1.8833333
60.0    4.2666667
87.0    2.0833333
49.0    4.4666667
80.0    2.5
60.0    4
92.0    1.7666667
43.0    4.3333333
89.0    2.1833333
60.0    4.4833333
84.0    3.8833333
69.0    3.3333333
74.0    3.7333333
71.0    4
108.0   1.95
50.0    5.2666667
77.0    2
57.0    4
80.0    2
61.0    4
82.0    2
48.0    4
81.0    3.5333333
73.0    2.1666667
62.0    4.5
79.0    2.0166667
54.0    4.15
80.0    4.2
73.0    4.3333333
81.0    1.9333333
62.0    4.65
81.0    3.8166667
71.0    4.0333333
79.0    4.1666667
81.0    4.6666667
74.0    1.8166667
59.0    4
81.0    3
66.0    4
87.0    2
53.0    4.45
80.0    2.05
50.0    4.25
87.0    1.9166667
51.0    4.6666667
82.0    1.7333333
58.0    4.3833333
81.0    1.7666667
49.0    4.6
92.0    1.8666667
50.0    4.45
88.0    1.6333333
62.0    5.0333333
93.0    1.8166667
56.0    5.1
89.0    1.6333333
51.0    4.2833333
79.0    2
58.0    4
82.0    2
52.0    4.5333333
88.0    2
52.0    4
78.0    2.9333333
69.0    4.7333333
75.0    3.9
77.0    1.95
53.0    4.1166667
80.0    1.8
55.0    4.6666667
87.0    1.8333333
53.0    4.7
85.0    2.1166667
61.0    4.7833333
93.0    1.8166667
54.0    4.1
76.0    4.65
80.0    4
81.0    2
59.0    4
86.0    4
78.0    4.2166667
71.0    4.1333333
77.0    3.9333333
76.0    3.75
94.0    4.4166667
75.0    2.4666667
50.0    4.1666667
83.0    3.8
82.0    4.3166667
72.0    3.8666667
77.0    4.6833333
75.0    1.7
65.0    4.9666667
79.0    4.2666667
72.0    4.5833333
78.0    4
77.0    4
79.0    4
75.0    4
78.0    1.9833333
64.0    4.6
80.0    0.8333333
49.0    4.9166667
88.0    1.7333333
54.0    4.5833333
85.0    1.7
51.0    4.75
96.0    1.8333333
50.0    4.5
80.0    1.8666667
78.0    4.45
81.0    4.45
72.0    4
75.0    4.8
78.0    4
87.0    4
69.0    2
55.0    4
83.0    1.9333333
49.0    4.5833333
82.0    2
57.0    3.7
84.0    2.8666667
57.0    4.8333333
84.0    3.45
73.0    4.3833333
78.0    1.8
57.0    4.4
79.0    2.4833333
57.0    4.5166667
90.0    2.1
62.0    4.35
87.0    4.3666667
78.0    1.7833333
52.0    4.9166667
98.0    1.8166667
48.0    4
78.0    4
79.0    4
65.0    3.8666667
84.0    1.85
50.0    4.7
83.0    2.0166667
60.0    4.4666667
80.0    1.8666667
50.0    4.1666667
88.0    1.9
50.0    4.25
84.0    3.25
74.0    4.2166667
76.0    1.8833333
65.0    4.9833333
89.0    1.85
49.0    4
88.0    1.9666667
51.0    4.7666667
78.0    4
85.0    2
65.0    4
75.0    4
77.0    2.3833333
69.0    4.4166667
92.0    4.2166667
68.0    4.3666667
87.0    2
61.0    4.45
81.0    1.75
55.0    4.5
93.0    1.6166667
53.0    4.7
84.0    2.5666667
70.0    3.7
73.0    4.2333333
93.0    1.9333333
50.0    4.35
87.0    4
77.0    4
74.0    4
72.0    4.2166667
82.0    4
74.0    4.1333333
80.0    1.8833333
49.0    4.4666667
91.0    1.95
53.0    4.2166667
86.0    1.7166667
49.0    4.45
79.0    4.25
89.0    3.9666667
87.0    4.3833333
76.0    1.9666667
59.0    4.45
80.0    4.2666667
89.0    1.9166667
45.0    4.4166667
93.0    3
72.0    4
71.0    2
54.0    4
79.0    3.2833333
74.0    1.8333333
65.0    4.6166667
78.0    1.8333333
57.0    4.6166667
87.0    4.6
72.0    4.25
84.0    1.9333333
47.0    4.9833333
84.0    1.9666667
57.0    4.3
87.0    4.2
68.0    4.5333333
86.0    4.4
75.0    4.6166667
73.0    2
53.0    4
82.0    4
93.0    3.9166667
77.0    2
54.0    4.5
96.0    1.8
48.0    4
89.0    2.75
63.0    4.7333333
84.0    3.9666667
76.0    1.95
62.0    4.9666667
83.0    1.85
50.0    4.8
85.0    4
78.0    4
78.0    4
81.0    4
78.0    4
76.0    4
74.0    4
81.0    2
66.0    4
84.0    1.9333333
48.0    4.3333333
93.0    1.6666667
47.0    4.7666667
87.0    1.95
51.0    4.6833333
78.0    1.9333333
54.0    4.4166667
87.0    2.1333333
52.0    4.0833333
85.0    2.0666667
58.0    4
88.0    4
79.0    2
----------------------------
*/
/*
FILE: SimulMultiMixt.txt
----------------------------
3004.304 2999.728
999.9897 999.4394
-3004.781 -3012.126
-1000.229 -1001.485
2999.628 3002.339
-2998.761 -2993.910
2998.667 3002.869
3003.893 3002.57
-1001.734 -1001.257
-2000.931 -1999.369
3001.768 3004.744
-2000.341 -2002.985
997.5842 1001.080
-2998.758 -2994.807
999.5247 1000.087
-2001.081 -2004.021
2999.685 2999.675
-2000.87 -2002.133
1999.598 2003.724
2000.418 1997.549
-1998.509 -1994.847
-3001.959 -3007.335
3002.824 3004.659
-999.19 -998.2142
3001.037 2997.392
-1000.876 -1000.375
3002.444 2999.052
-1997.655 -1993.932
-2001.840 -2005.267
2999.661 2997.404
-1001.306 -1004.252
2996.600 2998.745
-1000.040 -999.1095
3001.301 3002.272
-3000.788 -3001.361
2000.087 1997.800
-1998.887 -1996.164
-1998.981 -1997.216
3003.321 2996.554
-1999.562 -2000.295
1999.811 2003.156
-2000.109 -2000.011
2997.157 2994.752
-999.7652 -998.9055
-2997.312 -2989.935
2998.4 3000.388
-2002.123 -2004.949
3001.12 2995.75
-999.9782 -999.36
3000.708 3007.320
2999.995 3002.803
-1998.006 -1993.503
-999.2377 -996.242
3002.453 2995.903
-998.7183 -995.8268
-1997.808 -1994.313
3003.099 3000.962
-1001.063 -1000.613
1999.898 1998.651
-2000.120 -2000.917
1998.797 2000.728
-1999.369 -1996.611
2999.441 2995.395
-2997.893 -2995.354
999.7955 999.834
-999.9472 -999.9292
3000.014 2998.969
-2998.512 -2997.032
3003.026 3002.247
-3003.372 -3010.966
-2002.025 -2007.189
1001.959 1001.422
-999.4869 -1001.451
2999.248 2997.219
-997.9009 -993.2993
-1997.914 -1994.212
3000.36 3000.405
-2999.288 -2995.079
2998.896 2999.065
-3001.421 -3003.864
1998.610 2002.795
-2998.695 -2996.282
-1000.904 -1001.271
3003.326 2999.655
-999.8323 -1000.114
-2001.642 -2004.766
1998.336 2001.915
2998.704 2998.909
2000.486 2000.865
1997.705 1999.468
-997.9354 -997.1684
2998.924 2998.42
-1998.657 -1995.332
1999.262 1999.068
-2999.478 -2998.383
2998.898 2999.347
-1000.885 -1002.127
3000.775 2997.427
-2997.288 -2990.162
1000.397 1000.781
2001.746 2002.057
-1999.199 -1997.678
2999.183 3000.332
-2003.248 -2009.998
2996.452 3001.377
-3000.286 -2999.971
2999.171 2997.929
-2001.745 -2006.834
2999.897 2998.886
-2000.495 -2000.572
2999.689 3002.1
-2001.619 -2005.407
3004.17 3007.389
-1999.174 -1998.498
-1000.396 -998.482
2997.158 2997.378
-3000.383 -3001.587
2998.624 2999.861
-2000.254 -2000.926
2998.820 2992.603
-3001.253 -3004.519
2999.448 3002.957
2999.472 3000.938
-2000.265 -2002.360
3001.701 2996.05
3000.585 2998.108
-3000.477 -3002.500
2998.985 2995.697
-1001.914 -1003.488
2001.78 1997.338
-2001.101 -2004.454
3001.228 2997.88
3004.148 3001.628
-2999.979 -2995.844
999.1707 1000.314
-3000.308 -3001.626
2997.729 3000.547
-2996.241 -2989.673
1999.728 2000.104
-999.9964 -997.0822
-998.899 -996.2979
2997.620 3000.049
-999.3592 -998.953
3003.12 2999.222
-1999.341 -1998.018
2998.751 2995.865
-2998.926 -2995.948
3001.302 2996.635
3003.44 2998.507
-999.6835 -998.9812
2999.051 3002.369
3000.518 3001.917
-3000.007 -2999.229
3002.889 3003.656
-999.0518 -999.3894
-997.3627 -991.873
3006.051 3001.62
-1998.819 -1996.736
2997.242 3001.664
-2999.662 -2996.753
3000.037 2998.259
-999.3352 -998.7179
1998.284 1997.396
-2000.687 -2000.867
-999.434 -998.9294
2998.374 3003.636
1998.658 2004.333
-3000.387 -3000.381
3000.981 2997.31
-2998.722 -2997.411
2997.743 3001.69
-2000.338 -2002.003
-3000.666 -3001.451
-1998.143 -1994.015
1000.546 999.936
-3000 -2998.411
3000.561 3000.869
-2997.096 -2991.001
-1000.490 -1003.066
1998.296 2001.203
-1001.454 -1004.216
999.0231 999.9876
-1000.042 -1000.397
2999.507 2994.527
-999.909 -999.326
3002.21 2998.818
-1999.57 -1998.916
2996.357 2998.537
-3001.615 -3003.176
2998.06 2994.85
-2999.983 -3002.761
-2999.159 -2995.481
2997.256 3000.159
-1999.545 -1995.886
1997.417 1999.836
-999.6951 -996.8122
1999.833 1995.326
-3001.531 -3004.233
-2999.470 -2995.816
3000.395 3000.61
-2002.746 -2009.670
2999.46 2996.497
-2999.379 -3000.132
1999.044 2000.564
-2999.202 -2999.805
3001.011 3000.309
-1999.922 -2001.382
3000.769 2995.37
-1999.974 -1998.307
3001.914 3000.457
-999.7151 -1000.131
2996.803 2997.783
-3000.014 -3001.549
3001.834 3005.754
3000.904 2998.737
-1001.493 -1002.269
1999.074 2001.419
2002.533 2001.253
2997.132 2999.773
-1999.053 -1997.719
2998.074 3000.414
-2997.048 -2988.296
1000.574 1000.964
1999.641 1999.290
-3001.126 -3003.288
2002.337 1997.457
-999.5908 -1001.686
3002.067 2997.544
-1999.781 -2001.19
-1000.701 -1000.940
2999.817 3001.606
-2001.407 -2001.113
3000.329 3003.094
-999.896 -998.405
999.869 1000.450
-998.8001 -1001.948
2996.906 2996.442
-3001.594 -3002.568
2996.253 2996.614
-2997.47 -2993.483
2997.995 2995.835
-2000.740 -2003.850
2994.656 2995.717
-2998.741 -2996.197
-2001.957 -2004.150
3000.676 2999.483
-1000.817 -998.5766
-2001.865 -2003.786
2999.420 3001.125
-1000.623 -1000.188
2998.838 3000.177
3001.301 2998.563
-1000.316 -1002.888
2997.656 2997.626
-2000.009 -1998.223
999.3872 998.0468
-999.0963 -999.1255
2999.095 3001.740
-2000.025 -1999.064
3002.503 2999.841
-2998.084 -2993.746
2996.427 3000.096
2998.917 3002.538
-1997.887 -1991.057
2998.207 3000.203
-2003.252 -2008.997
3005.32 2999.812
-2001.698 -2002.610
3000.335 3003.886
-1000.608 -999.4473
-1001.272 -999.4146
-997.6858 -997.334
-2000.193 -1997.865
3000.231 3003.439
-1998.739 -1996.693
-1999.38 -2001.338
2998.781 2997.656
-1998.827 -1997.938
998.9784 999.8173
-1998.212 -1996.797
-2001.403 -2002.766
1999.961 1995.357
-2998.313 -2992.824
3000.553 3002.303
-2002.250 -2003.313
999.1399 999.9247
-1000.265 -998.3947
3000.675 3001.272
-3001.144 -3003.540
2998.249 3003.805
-3000.89 -3006.008
-2998.244 -2995.879
3000.178 3000.814
-2003.181 -2010.098
3003.637 3001.442
-2001.975 -2004.435
2995.773 2999.05
1002.442 1002.043
-999.8246 -998.1977
2996.662 2996.353
-1998.417 -1995.785
3001.825 2995.978
-1000.395 -998.9616
2998.964 2998.915
-998.497 -998.556
3003.115 3000.914
-998.8724 -997.9654
3001.001 2999.617
-3001.585 -3006.164
2996.090 3000.753
-1999.157 -1996.497
3000.496 3006.14
-2001.897 -2003.836
2996.857 3003.855
-3000.059 -3000.531
2998.825 3001.325
-1000.316 -999.221
3003.694 2997.389
-999.9392 -999.9414
-997.368 -992.8586
1000.586 999.9192
2998.122 2995.575
-2998.224 -2992.437
2998.493 2994.627
-999.743 -1001.524
999.795 1000.563
-999.296 -996.5756
-1998.582 -1995.443
1998.377 2001.089
-1000.134 -999.3285
-3001.383 -3005.914
2999.624 3002.788
3000.402 2999.362
-2998.771 -2994.665
3002.7 3001.513
-3003.29 -3012.111
3006.500 2995.23
-998.8673 -996.8437
-2999.753 -2999.702
1999.356 2000.188
-3001.845 -3002.828
2996.38 3002.259
-2998.8 -2995.446
3001.337 3003.913
-3000.744 -3004.249
-999.9859 -999.5777
2997.997 3001.618
3000.602 2999.065
-2000.255 -1999.339
1000.455 999.894
-2000.251 -2001.592
1999.85 2000.776
-1999.630 -1996.721
2999.31 2999.459
-1000.479 -1001.714
-2001.47 -2004.999
-1000.356 -1001.604
3000.562 3002.476
-999.8195 -1001.356
3000.464 3001.359
-1999.459 -1997.395
2999.073 2999.235
-2998.161 -2994.378
-1997.233 -1991.231
1000.580 1000.259
-1000.228 -999.1823
3000.687 2998.08
-999.4822 -1000.081
3001.615 3004.265
-999.9256 -998.8955
3002.460 2995.749
-1999.585 -1997.955
-3001.291 -3008.248
-1001.134 -1004.433
2999.655 2999.496
-3001.588 -3006.378
2998.393 3000.679
-1000.474 -995.6386
2999.083 2996.948
-1000.912 -1001.923
1999.329 1997.627
-1002.233 -1003.777
3002.931 2995.268
-1999.734 -1997.707
2998.960 2998.900
-2000.196 -1999.428
1999.626 1997.486
-3001.162 -3006.204
-3000.469 -3001.269
3003.451 2997.303
-2000.927 -2001.455
2993.422 3003.312
1000.378 1001.984
-3002.998 -3008.872
-1999.54 -1998.619
2998.889 2998.329
-3001.605 -3003.517
1999.547 2002.792
-999.6174 -992.3412
3005.815 3007.080
-3000.137 -3003.285
1000.907 999.7483
-999.054 -1000.026
-2998.31 -2992.955
2001.745 2000.067
-2002.174 -2006.188
2996.999 3001.385
-1996.952 -1989.735
3004.060 3002.867
-2001.101 -2001.582
-1001.816 -1003.474
3002.479 2998.887
-1000.396 -1000.659
2000.581 2000.536
-3001.053 -3004.483
2997.319 3000.194
-1000.646 -1000.306
3002.043 3002.161
-2000.659 -2001.982
3001.275 2997.543
-2998.575 -2994.69
2000.479 2000.091
-2997.968 -2992.048
998.2359 1000.957
-999.6546 -997.9179
-1999.125 -1998.468
-1000.506 -1003.752
-3000.081 -3001.651
-2000.669 -2002.579
-3001.807 -3009.099
3001.726 3004.607
-2002.601 -2008.281
2998.389 3002.036
-2000.34 -2000.554
1998.082 1998.952
-3002.541 -3008.188
-2000.098 -1999.294
-999.5467 -999.2677
3000.167 2993.488
-1998.365 -1994.283
-2999.877 -2999.677
3000.998 3000.063
-2000.009 -2000.967
3002.725 2998.302
-2996.646 -2991.007
1000.944 1000.813
-3001.176 -3005.612
2998.176 2996.223
-1998.400 -1999.181
3003.558 3004.876
-2001.439 -2004.296
3000.901 2999.858
2999.747 2998.425
-2000.449 -1999.699
3001.206 3002.123
-2000.399 -2002.892
2001.016 1999.741
-999.6755 -996.1678
-2000.454 -2001.534
3001.705 3001.621
-2000.683 -2002.322
2994.689 2999.535
-1001.434 -1003.490
-1998.438 -1994.810
3000.143 2995.314
-998.8034 -997.0654
-2000.700 -2001.138
3003.000 2996.708
-1999.114 -1998.778
1998.368 1996.1
-2999.28 -2995.635
-1000.069 -1003.019
3001.57 3004.533
-998.3188 -993.7878
999.4527 1000.702
-1998.245 -1992.622
2997.586 3000.31
-1000.967 -1001.762
2002.868 2003.006
2000.432 2001.34
-999.4901 -1000.316
3001.377 3006.219
-1000.308 -1001.089
3002.553 3001.231
-1000.087 -999.3522
2001.002 1997.633
-2000.878 -2002.639
2999.79 3001.356
-1000.279 -997.9044
2995.6 3003.576
-1000.167 -999.6996
-3000.705 -2999.701
2998.96 2998.996
-1001.134 -1004.614
2999.918 2998.224
-1998.649 -1996.059
3003.986 3003.953
-1001.474 -1003.706
1999.909 2001.122
-1998.953 -1996.773
2995.295 3000.48
-3000.037 -2998.618
2003.030 1998.851
-2001.192 -2002.717
-999.7503 -1000.977
3001.41 2999.909
3001.898 2999.933
-2999.839 -2999.565
1999.821 2000.238
-3001.15 -3003.916
-2002.705 -2009.94
2001.635 1999.320
-998.7015 -1000.214
2995.553 3001.197
2996.987 2999.761
-2999.542 -2995.21
2998.386 3001.664
-2000.222 -1999.62
-2000.722 -1997.576
3001.735 2997.04
-3001.231 -3002.395
-2999.443 -2998.111
2998.825 2998.943
-2003.404 -2009.456
2996.978 3008.396
-3000.292 -2999.315
1999.602 2000.886
-2001.649 -2005.220
2999.386 2997.648
-999.3017 -999.9146
3002.205 3000.548
-1001.431 -999.254
3002.627 3002.794
-2999.417 -3001.256
2996.061 2998.684
-1999.58 -1999.931
2996.145 2999.757
-3001.982 -3009.056
1996.193 1999.333
-3002.789 -3007.668
3001.178 2998.931
-1999.588 -1997.623
-2996.458 -2990.736
3004.736 2998.995
999.1594 1000.664
-2001.548 -2003.734
2997.774 3000.687
3004.005 2999.886
-2001.557 -2004.724
2999.990 3001.954
-2998.150 -2996.513
2000.182 1998.146
-1998.310 -1995.577
-2998.648 -2999.086
2999.035 3003.359
-1999.527 -1998.347
2998.852 3003.027
-2000.084 -1999.248
2997.07 3000.635
-2000.114 -2001.64
-2000.402 -2001.196
3005.783 3000.06
-1999.53 -1999.285
3001.338 2995.462
-999.3094 -999.6354
-1998.226 -1993.737
3002.848 3004.124
-2995.518 -2987.144
1999.523 2002.858
2997.610 3002.344
-1997.975 -1993.603
2996.751 3000.039
-2996.984 -2995.601
2995.415 2997.566
-1999.760 -1997.33
2996.101 3000.682
-1000.389 -997.9486
2000.568 2000.754
-2001.352 -2004.949
3001.433 3001.343
-2999.108 -2995.303
2999.503 2996.342
-2998.537 -2994.602
998.9075 999.2397
-1000.039 -998.9075
1001.840 1001.193
-999.9204 -999.2124
1999.070 1999.796
-3001.283 -3004.27
3000.104 2997.371
-1999.916 -1998.088
3001.404 2997.309
-1997.858 -1991.688
3002.032 2998.617
2000.414 1996.242
-1000.292 -1004.755
2998.057 2997.610
2000.388 2002.701
-1000.293 -999.2989
2998.296 2998.176
2998.47 3001.028
-2999.186 -2997.825
2001.035 2000.455
-2002.972 -2009.378
2998.829 3002.045
-3000.683 -2999.974
2997.007 3002.491
1997.755 2001.970
-3001.629 -3005.4
999.2646 1000.133
-1998.964 -1994.080
-2001.429 -2002.939
3001.787 3006.677
-2996.933 -2993.579
-2999.684 -3000.712
3002.095 2998.404
-2998.823 -2999.016
2998.851 3005.596
-1996.168 -1988.716
-2001.384 -2003.435
3001.589 3004.278
-1001.861 -1002.775
3001.551 2998.327
-2999.901 -3000.672
3000.265 3003.473
-999.8796 -1001.308
3001.856 3003.193
-999.6495 -997.3809
-2001.780 -2004.632
1999.456 2004.616
-1999.303 -2000.023
2996.62 2998.812
-1001.909 -1004.435
-2001.513 -2004.485
2002.084 1999.977
-1998.238 -1996.471
2999.378 2997.009
-1997.521 -1990.449
2998.064 2996.516
-2997.919 -2993.742
1999.281 1998.769
-2999.65 -3000.993
-3000.478 -3003.463
2999.457 2998.032
-999.9045 -1001.159
3001.139 2995.721
-2999.877 -3000.366
3000.864 2997.591
-3001.097 -3004.343
2997.979 3000.185
3000.139 2994.032
-1000.758 -1001.52
2001.040 2000.45
-1999.92 -2000.162
-3000.106 -3001.387
3001.263 2999.325
-1000.506 -997.5255
3001.377 2998.921
-2000.128 -1999.669
2999.662 2997.678
-1000.403 -1000.601
3004.973 3005.169
-1997.996 -1994.101
2998.474 3001.009
3000.227 3004.509
-3000.494 -3004.042
-3000.66 -2999.579
2995.959 2994.722
-1998.504 -1995.037
2999.884 3000.017
-3000.052 -3000.900
1999.61 2000.309
-1998.178 -1993.967
2994.122 2997.952
-1999.226 -1999.862
-2000.854 -2003.218
1999.905 1995.785
-3002.892 -3008.037
2999.709 3001.042
-1998.022 -1993.152
2002.511 2000.688
-1000.549 -997.8874
3002.048 2993.601
-2999.415 -2995.356
3001.741 2999.238
-2002.594 -2005.737
3000.998 3002.79
2996.100 2997.894
-2000.293 -2001.501
3001.517 2997.793
-2999.75 -2995.744
3000.352 2995.858
-1001.082 -1006.404
999.6696 1000.280
-2000.376 -2003.161
999.1343 999.8428
-1000.515 -999.256
2998.882 2999.137
1997.755 1998.042
-3001.922 -3003.07
2996.897 2998.828
-1999.867 -1998.403
2999.091 3004.373
-2002.255 -2006.519
3000.554 3002.157
-2001.368 -2003.056
1000.063 1000.857
-1999.376 -1998.379
3001.082 2999.958
-3001.979 -3005.445
-2999.952 -3001.986
-999.2618 -995.3472
2995.24 3001.315
-2000.304 -2002.112
-999.9505 -1000.272
2999.264 2999.621
-1000.435 -996.6763
2002.033 1997.387
-2002.055 -2008.600
3001.757 3003.628
-2000.158 -2000.793
2999.875 2998.331
-2999.112 -2994.939
3001.579 3008.931
-2000.493 -2001.809
-1000.852 -1002.243
2998.795 2999.669
-2001.245 -2003.176
3000.823 3000.057
-998.0543 -998.0421
2001.01 2000.866
-2998.468 -2996.543
1000.092 997.8436
2998.864 2993.092
1001.056 1000.225
-2000.709 -2002.378
2000.437 1998.733
-2001.759 -2004.074
-1000.013 -1003.657
-999.2601 -998.2803
2998.384 3000.629
-2997.447 -2991.117
3001.110 3001.146
-998.857 -999.4817
-3001.534 -3004.025
2997.668 2999.290
-1998.738 -1996.644
2999.396 2996.945
-1999.864 -1999.461
3000.519 3002.39
-2999.131 -2998.895
3001.957 3001.976
-3000.146 -2998.877
-3000.582 -3000.047
3001.606 2997.315
-2001.104 -2005.718
3002.080 2999.271
-1000.381 -1000.397
-2002.530 -2007.708
1000.116 1002.130
-2000.191 -2000.202
3000.511 2993.974
-3000.465 -3003.954
-2998.476 -2993.326
3002.172 3005.279
-2999.887 -2998.169
-3001.472 -3006.437
2000.71 1997.706
-2999.251 -2998.025
2999.36 2998.357
-1998.389 -1996.043
3000.707 2998.435
-2000.405 -2001.167
3002.361 2998.942
-3001.263 -3003.371
-998.8305 -999.953
2996.598 2996.838
-2998.359 -2995.026
3000.585 2999.737
-3000.381 -3003.229
3000.073 3003.341
3004.818 3000.489
-2998.891 -2996.964
3001.299 2998.074
3001.478 3003.728
-999.8119 -999.2266
1999.667 1999.334
-1998.247 -1993.064
2999.879 2999.315
-1000.809 -1002.779
3001.975 3003.061
-3000.61 -3004.558
2997.974 2998.624
-998.1219 -998.498
-999.5782 -999.9918
3002.692 2998.756
-3001.234 -3003.827
-2001.767 -2004.014
3001.963 2998.442
-1999.511 -1999.027
2999.496 2999.428
-998.7244 -997.0472
3001.153 2994.090
2004.669 2002.257
-3004.195 -3014.114
999.2033 998.5002
-3002.599 -3007.500
3000.853 2995.06
-1998.299 -1994.783
2996.676 2996.185
-3001.791 -3004.054
2999.994 3007.154
-999.9216 -1001.964
3001.713 2998.594
-1998.671 -1995.051
1999.609 2000.552
2997.384 3001.759
-1998.472 -1993.048
2999.158 3001.653
2999.088 2994.732
-998.9248 -994.5332
2999.749 2999.743
-1999.278 -1998.440
3001.35 2993.203
-2997.93 -2992.622
-1000.598 -1002.856
3000.949 3003.487
-3000.787 -3002.028
2997.919 2997.301
-998.5783 -997.3562
3003.719 2999.621
-999.747 -998.2943
3000.052 2998.085
-999.821 -1000.343
1998.24 1995.060
-2996.798 -2991.845
3001.545 2998.39
2999.548 3000.971
-2997.231 -2990.883
-2999.509 -2996.778
2999.844 2994.318
-2000.272 -2000.439
-2999.576 -2997.717
999.9042 999.0502
-998.5383 -996.9359
3002.853 2999.570
-2999.691 -2998.196
2997.258 2999.937
-3000.738 -2999.517
2999.388 3001.731
-3003.782 -3011.77
3000.104 2996.564
-3000.397 -3000.633
2992.694 3003.977
2998.722 2995.534
-999.2181 -999.3283
997.1567 1000.840
-1000.960 -999.6184
3000.635 2997.199
-1001.642 -1005.562
2997.564 3003.98
-2000.233 -1998.458
2998.956 3000.778
-999.6644 -997.7177
3003.617 2999.453
-1997.485 -1992.433
1999.473 1998.912
-1998.686 -1995.214
-999.2252 -998.9433
2998.270 2996.036
2998.117 2996.830
-1001.207 -1004.730
2998.597 3001.075
-3001.931 -3007.653
2000.276 1999.950
-1000.085 -1000.334
3001.639 3002.132
-2999.621 -3000.436
2998.775 2998.762
-2000.926 -2003.437
-3001.161 -3003.957
-1000.785 -1002.051
2999.054 2999.478
-3000.811 -2999.436
3001.154 3002.664
-1001.747 -1000.391
2997.563 2997.131
3002 2999.525
-2002.770 -2008.881
3003.124 3001.364
-999.3785 -997.6369
2999.793 2998.37
-3002.148 -3004.668
-3002.377 -3005.947
-3001.358 -3005.263
998.7957 1000.371
-1001.57 -1008.674
999.4071 999.9502
-3000.751 -3000.241
3003.43 3002.177
-1999.357 -1998.792
3003.532 3005.467
-3003.675 -3008.871
2002.013 1996.231
-2001.684 -2004.500
2997.146 2994.499
-1001.547 -1006.221
-3002.618 -3007.668
2998.411 3004.943
-1999.88 -1998.581
2998.808 2998.267
-998.7096 -997.0627
-2998.878 -2996.285
2996.496 2998.584
3000.793 3003.500
3002.695 2998.586
-2999.768 -2995.828
3001.109 3002.684
-999.6794 -993.9117
-2999.443 -2996.587
3000.511 3006.714
2000.058 1999.971
-1999.949 -2000.761
2997.008 2995.138
-1999.176 -1999.629
2997.73 3002.41
3002.298 3001.874
-999.5121 -1001.634
-1000.776 -1004.024
3000.859 3000.063
-3003.636 -3007.995
2998.21 3001.732
-2001.333 -2005.080
-1000.021 -998.494
2999.704 2995.777
-999.8584 -999.4113
3001.246 3005.492
2999.116 2993.948
-2996.282 -2986.673
2996.106 2995.788
-999.0806 -998.3964
3004.883 3006.329
-998.2305 -997.3284
3001.152 3001.474
-1001.512 -1005.402
2996.444 3003.170
-2000.477 -1999.112
3000.798 2997.39
-1000.761 -997.3236
-998.5752 -991.8198
1999.179 1998.832
-2998.771 -3000.834
2995.741 3000.159
-3001.192 -3002.024
2997.245 2999.461
-3001.101 -3002.580
2000.009 2002.390
-2997.963 -2994.801
-1001.432 -999.99
-999.9742 -996.8294
2000.1 2000.762
-3000.591 -3002.217
-2000.577 -1999.195
2000.969 1998.939
-999.8949 -1000.148
998.4 999.5562
-999.1491 -998.7318
2000.864 2000.265
-2000.666 -2003.094
1000.876 999.3146
-1996.685 -1988.968
3000.196 3004.71
-2000.427 -2000.448
3000.581 3004.567
3001.191 2997.663
999.6385 1000.425
3000.488 2996.724
-999.184 -1001.419
2000.849 1998.488
-1000.203 -997.7413
1999.527 2005.166
-1998.227 -1993.904
2998.291 2996.252
-1998.616 -1995.792
2998.203 3002.283
-2000.078 -1999.733
3001.204 3001.052
-3001.648 -3006.389
3000.102 2996.077
-2999.746 -3002.018
-1000.362 -1000.512
3000.680 2998.296
-2999.161 -2997.878
1998.723 1999.741
-3001.630 -3002.259
-3001.249 -3007.764
-999.483 -999.8187
2998.657 3000.331
-1000.189 -1002.195
3001.35 2999.44
-----------------------------
*/
#endif _RDLL_
