/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hive;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.TreeSet;

class DatabaseConnection {
    private String driver;
    private Connection connection;
    private DatabaseMetaData metaData;
    private final String url;
    private final String username;
    private final String password;
    private Schema schema = null;

    public DatabaseConnection(String driver, String url, String username, String password) {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return this.getUrl();
    }

    boolean connect() throws SQLException {
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        boolean foundDriver = false;
        try {
            foundDriver = DriverManager.getDriver(this.getUrl()) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
        this.setConnection(DriverManager.getConnection(this.getUrl(), this.username, this.password));
        this.setDatabaseMetaData(this.getConnection(false).getMetaData());
        return true;
    }

    public Connection getConnection(boolean reconnect) throws SQLException {
        if (reconnect) {
            this.reconnect();
            return this.connection;
        }
        if (this.connection != null) {
            return this.connection;
        }
        this.connect();
        return this.connection;
    }

    public void reconnect() throws SQLException {
        this.close();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.setConnection(null);
            this.setDatabaseMetaData(null);
        }
    }

    public String[] getTableNames() {
        Schema.Table[] t = this.getSchema().getTables();
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; t != null && i < t.length; ++i) {
            names.add(t[i].getName());
        }
        return names.toArray(new String[names.size()]);
    }

    Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    DatabaseMetaData getDatabaseMetaData() {
        return this.metaData;
    }

    void setDatabaseMetaData(DatabaseMetaData metaData) {
        this.metaData = metaData;
    }

    String getUrl() {
        return this.url;
    }

    class Schema {
        private Table[] tables = null;

        Schema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Table[] getTables() {
            if (this.tables != null) {
                return this.tables;
            }
            LinkedList<Table> tnames = new LinkedList<Table>();
            try {
                ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getTables(DatabaseConnection.this.getConnection(false).getCatalog(), null, "%", new String[]{"TABLE"});
                try {
                    while (rs.next()) {
                        tnames.add(new Table(rs.getString("TABLE_NAME")));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tables = tnames.toArray(new Table[0]);
            return this.tables;
        }

        Table getTable(String name) {
            Table[] t = this.getTables();
            for (int i = 0; t != null && i < t.length; ++i) {
                if (!name.equalsIgnoreCase(t[i].getName())) continue;
                return t[i];
            }
            return null;
        }

        class Table {
            final String name;
            Column[] columns;

            public Table(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            class Column {
                final String name;

                public Column(String name) {
                    this.name = name;
                }
            }
        }
    }
}

