% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSpectrogram.R
\name{PlotSpectrogram}
\alias{PlotSpectrogram}
\title{Calculates and Plots spectrogram}
\usage{
PlotSpectrogram(HRVData, size, shift, sizesp = NULL, freqRange = NULL,
  scale = "linear", verbose = NULL, showLegend = TRUE, Tags = NULL,
  Indexes = NULL, eplim = NULL, epColorPalette = NULL,
  markEpisodes = TRUE, ymark = NULL, showEpLegend = TRUE,
  epLegendCoords = NULL, main = "Spectrogram of the HR  series",
  xlab = "Time (sec.)", ylab = "Frequency (Hz.)", ylim = freqRange,
  Tag = NULL, ...)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information
related to it}

\item{size}{Size of window for calculating spectrogram (seconds)}

\item{shift}{Displacement of window for calculating spectrogram (seconds)}

\item{sizesp}{Points for calculation (zero padding). If the user does not 
specify it, the function estimates a propper value.}

\item{freqRange}{Vector with two components specifying the frequency range 
that the program should plot. If the user does not specify it, the function 
uses the whole frequency range. It is possible to specify the frequency range
using the ylim parameter.}

\item{scale}{Scale used to plot spectrogram, linear or logarithmic}

\item{verbose}{Deprecated argument maintained for compatibility, 
use SetVerbose() instead}

\item{showLegend}{Logical argument. If true, a legend of the color map is 
shown (default is TRUE)}

\item{Tags}{List of tags to specify which episodes, as apnoea or oxygen 
desaturation, are included in the plot. \emph{Tags}="all" plots all episodes present
in the data.}

\item{Indexes}{List of indexes of episodes (see ListEpisodes())
to specify which episodes are included in the plot.
\emph{Indexes}="all" plots all episodes present in the data.}

\item{eplim}{Two-component vector specifying the y-range (min,max) for the
vertical lines limiting each episode.}

\item{epColorPalette}{Vector specifying the color of each of the episodes that 
will be plotted. The length of colorPalette should be equal or greater than 
the number of different episodes to be plotted.}

\item{markEpisodes}{Boolean specyfing if a horizontal mark should be included 
for each of the episodes.}

\item{ymark}{Two-component vector specifying the y-range (min,max) for the
horizontal marks. Only used if markEpisodes = TRUE.}

\item{showEpLegend}{Boolean argument. If TRUE, a legend of the episodes is 
included.}

\item{epLegendCoords}{Two-component vector specifiying the coordinates where
the legend should be placed. By defaul, the legend is placed on top of the
plot.}

\item{main}{A main title for the plot.}

\item{xlab}{A label for the x axis.}

\item{ylab}{A label for the y axis}

\item{ylim}{Numeric vectors of length 2, giving the x and y coordinates 
range. If freqRange is specified, ylim is overwriten by it because of backward
compatibility.}

\item{Tag}{Deprecated argument maintained for
compatibility, use Tags instead.}

\item{...}{Other graphical parameters. See 
\code{\link[graphics]{filled.contour}}.}
}
\description{
Plots spectrogram of the heart rate signal as calculated by
CalculateSpectrogram() function
}
\details{
PlotSpectrogram
}
\note{
PlotSpectrogram with \emph{showLegend = TRUE} uses the layout function 
and so is restricted to a full page display. Select \emph{showLegend = FALSE}
in order to use the layout function.
}
\examples{
\dontrun{

# Read file "a03" from the physionet apnea-ecg database
library(RHRV)
HRVData <- CreateHRVData()
HRVData <- LoadBeatWFDB(HRVData,RecordName="test_files/WFDB/a03")
HRVData <- LoadApneaWFDB(HRVData,RecordName="test_files/WFDB/a03")
# Add other type of episode for a more complete example (this episode does
# not have any physiological meaning)
HRVData <- AddEpisodes(HRVData,InitTimes=c(4500),Durations=c(1000), 
                       Tags="Other", Values = 1)         
# Calculating heart rate signal:
HRVData <- BuildNIHR(HRVData)
 
# Filtering heart rate signal:
HRVData <- FilterNIHR(HRVData)

# Interpolating heart rate signal:
HRVData = InterpolateNIHR(HRVData)
 
# Calculating and Plotting Spectrogram
spctr <- PlotSpectrogram(HRVData, size = 120, shift = 10, sizesp = 1024,
         freqRange=c(0,0.14), color.palette = topo.colors)
         
spctr <- PlotSpectrogram(HRVData,size=120, shift=60, Tags="all", 
                         ylim=c(0,0.1),
                         showLegend=T, 
                         eplim = c(0,0.06),
                         epColorPalette=c("skyblue","white"), 
                         showEpLegend = T,
                         epLegendCoords = c(15000,0.08), 
                         ymark=c(0.001,0.002))
}
}
\author{
M. Lado, A. Mendez, D. Olivieri, L. Rodriguez, X. Vila. C.A. Garcia
}
\references{
L. Rodriguez-Linares, A. Mendez, M. Lado, D. Olivieri, X. Vila, 
I. Gomez-Conde, "An open source tool for heart rate variability spectral 
analysis", Computer Methods and Programs in Biomedicine 103, 39-50, 
doi:10.1016/j.cmpb.2010.05.012 (2011)
}
\seealso{
\code{\link{CalculateSpectrogram}} for spectrogram calculation
}
\keyword{hplot}

