% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Init.R
\name{Init}
\alias{Init}
\title{Initialize the Google Analytics query parameters}
\usage{
Init(end.date = NULL, metrics = NULL, start.date = NULL, title = NULL,
  dimensions = NULL, filters = NULL, segments = NULL)
}
\arguments{
\item{end.date}{End Date for fetching Analytics Data. End Date must be of the
  format "\%Y-\%m-\%d"}

\item{metrics}{A vector of up to 10 metrics, either as a single string or a
  vector or strings. E.g. "ga:sessions" or c("ga:sessions", "ga:bounces").}

\item{start.date}{Start Date for fetching Analytics Data. Start Date must be
  of the format "\%Y-\%m-\%d"}

\item{title}{Title of unsampled report.}

\item{dimensions}{Optional. A vector of up to 4 dimensions, either as a
  single string or a vector or strings, E.g. "ga:source,ga:medium" or
  c("ga:source", "ga:medium").}

\item{filters}{Optional.The filter string for the GA request.e.g. "ga:medium==referral".}

\item{segments}{Optional.An advanced segment definition to slice and dice
  your Analytics data.}
}
\value{
List of all the Query Parameters initialized by the user
}
\description{
This function takes all the query parameters and combines them into a single
list that is to be passed as an argument to \code{\link{QueryBuilder}}. Note
that parameter validation is performed when the \code{\link{QueryBuilder}}
object is created
}

