% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modDownload.R
\name{modDownload}
\alias{modDownload}
\title{Download MODIS images from a search list}
\usage{
modDownload(
  searchres,
  AppRoot,
  username = NULL,
  password = NULL,
  nattempts = 5,
  verbose = FALSE,
  extract.tif = FALSE,
  overwrite = FALSE,
  raw.rm = FALSE,
  ...
)
}
\arguments{
\item{searchres}{the output from the \code{\link{modSearch}} function.}

\item{AppRoot}{the directory where the images will be saved.}

\item{username}{NASA’s `EarthData' username.}

\item{password}{NASA’s `EarthData' password.}

\item{nattempts}{the number of attempts to download an image in case it
becomes corrupted.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints running stages and warnings.}

\item{extract.tif}{logical argument. If \code{TRUE}, extracts all the layers
from hdf files and saves them as GTiff.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{raw.rm}{logical argument. If \code{TRUE}, removes the raw images.}

\item{...}{argument for nested functions:
 \itemize{
       \item \code{dates} a vector with the capturing dates being considered
  for downloading.
       \item \code{bFilter} a vector with the bands to be extracted when \code{extract.tif=TRUE}. If not
  supplied, all bands are extracted.
}}
}
\value{
this function does not return anything. It saves the imagery as
`hdf’ (and GTiff files) in a folder called `raw’ (`tif’) in the
 \code{AppRoot} directory.
}
\description{
\code{modDownload} downloads the images from a list of uniform resource 
locators (URLs) generated by the \code{\link{modSearch}} function from NASA’s
`EartData' plataform. The images are saved as GTiff files in the 
\code{AppRoot} directory.
}
\details{
\code{modDownload} is able to download MODIS Terra and Aqua products.
These products are published in the 
\href{https://earthdata.nasa.gov}{`EarthData' Platform}.
The platform is supported by the Earth Observing System Data and Information
System (EODIS) and managed NASA’s Earth Science Data Systems (ESDS).
\code{modDownload} requires credentianls from an `EarthData' account to
access the NASA’s web data service, which can be obtained 
\href{https://urs.earthdata.nasa.gov/users/new}{here}.

When \code{extract.tif = TRUE}, the function decompresses the imagery. If
only a subset of bands is required, band names can be provided through the
\code{bFilter} argument. The band names are specified by “B” and the two-digit
band number (e.g., “B01”). Image decompression duplicates the information due
to the presence of both, compressed and decompressed images. Set 
\code{raw.rm = TRUE} to remove former ones.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
sres <- modSearch(product = "MYD13A2",
                  startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                  endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                  collection = 6,
                  extent = ex.navarre)
head(sres)
# download the first image in sres
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)
wdir.mod <- file.path(wdir,"Modis","MYD13A2")
wdir.mod.hdf <- file.path(wdir.mod,"hdf")
modDownload(mList[1], 
            username = "username", 
            password = "password",
            AppRoot = wdir.mod.hdf)
# download all images in mList
modDownload(sres, 
            username = "username", 
            password = "password",
            AppRoot = wdir.mod.hdf)
}
}
