% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsCloudMask.R
\name{lsCloudMask}
\alias{lsCloudMask}
\title{Create cloud masks for Landsat images}
\usage{
lsCloudMask(src, AppRoot, sensitivity = 2800, overwrite = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{src}{the path to the folder with the untarred images from Landsat-7 or
Landsat-8.}

\item{AppRoot}{the directory where cloud masks are saved.}

\item{sensitivity}{\code{numeric} argument. Defines the sensitivity of the
cloud detection method.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{...}{arguments for nested functions.}
}
\value{
this function does not return anything. It creates new GTiff files
for a new cloud band (CLD) inside the folder of every image.
}
\description{
\code{lsCloudMask} creates a cloud mask derived from the band for quality
assurance (BQA) from Landsat-7 or Landsat-8 time series. The function is
applied to untarred images, such as those resulting from 
\code{\link{lsDownSearch}} or \code{\link{lsDownload}}. The result is a new
image band, called cloud (CLD), that is saved as separate GTiffs.
}
\details{
The valid range for the \code{sensitivity} threshold is 0-8000. By defualt,
the argument is set to 2800. We recommend 600 and 2800 for Landsat-7 and
Landsat-8 respectively.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)

# search and download images from Landsat-8 between
# 01-01-2018 and 20-01-2018 for the region of Navarre
lsDownload(satellite = "ls8",
           username = "username",
           password = "password",
           startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
           endDate = as.Date("20-01-2018", "\%d-\%m-\%Y"),
           pathrow = list(c(200, 31), c(200, 30)),
           untar = TRUE,
           AppRoot = src)
           
# define the path where the GTiff images are located
src.ls8 <- file.path(src,"Landsat8")
src.untar <- file.path(src.ls8,"untar")
# calculate the cloud mask from QC layer
lsCloudMask(src=src.untar,
            overwrite=TRUE,
            AppRoot = src.ls8)
            
# mosaic and crop the imagery
lsMosaic(src = src.untar,
         AppRoot = src.ls8,
         out.name = "Navarre",
         extent = ex.navarre,
         bFilter = c("CLD"),
         gutils = TRUE, # using gdalUtils
         overwrite = TRUE) # overwrite
         
# generate the path where mosaicked images are located
src.navarre <- file.path(src,"Landsat8","Navarre")
# load the B1 layer and calculate the CLD layer
tiles.path <- list.files(src.navarre,
                         full.names = TRUE,
                         recursive = TRUE,
                         pattern = "\\\\.tif$")
cloud.tiles <- tiles.path[grepl("CLD",tiles.path)]
b1.tiles <- tiles.path[grepl("B1.tif",tiles.path)]
cloud.tiles.ras <- lapply(cloud.tiles,raster)
b1.tiles.ras <- lapply(b1.tiles,raster)

# calculate cloud free b1 layers
b1.cloud.free <- b1.tiles.ras[[1]] * cloud.tiles.ras[[1]]
spplot(b1.cloud.free)
}
}
