% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metadata.R
\name{list_dimsmets}
\alias{list_dimsmets}
\title{Lists all the dimensions and metrics for a particular report type}
\usage{
list_dimsmets(report.type = "ga")
}
\arguments{
\item{report.type}{character. Report type. Allowed Values: "ga". Where "ga" corresponds to the Core Reporting API.}
}
\value{
A data.frame contains dimensions and metrics for a particular report type.
\item{id}{Parameter name.}
\item{type}{The type of column: \code{DIMENSION}, \code{METRIC}.}
\item{data.type}{The type of data this column represents: \code{STRING}, \code{INTEGER}, \code{PERCENT}, \code{TIME}, \code{CURRENCY}, \code{FLOAT}.}
\item{group}{The dimensions/metrics group the column belongs to.}
\item{status}{The status of the column: \code{PUBLIC}, \code{DEPRECATED}.}
\item{ui.name}{The name/label of the column used in user interfaces (UI).}
\item{description}{The full description of the column.}
\item{allowed.in.segments }{Indicates whether the column can be used in the segment query parameter.}
\item{replaced.by}{The replacement column to use for a column with a \code{DEPRECATED} status.}
\item{calculation}{Only available for calculated metrics. This shows how the metric is calculated.}
\item{min.template.index}{Only available for templatized columns. This is the minimum index for the column.}
\item{max.template.index}{Only available for templatized columns. This is the maximum index for the column.}
\item{premium.min.template.index}{Only available for templatized columns. This is the minimum index for the column for premium properties.}
\item{premium.max.template.index}{Only available for templatized columns. This is the maximum index for the column for premium properties.}
}
\description{
This dataset represents all of the dimensions and metrics for the reporting API with their attributes. Attributes returned include UI name, description, segments support, etc.
}
\examples{
\dontrun{
ga_meta <- list_dimsmets("ga")
# a count of parameters types
table(ga_meta$type)
# parameters groups
table(ga_meta$group)
# get a deprecated parameters was replaced by
subset(ga_meta, status == "DEPRECATED", c(id, replaced.by))
# get a calculation metrics
subset(ga_meta, !is.na(calculation), c(id, calculation))
# get a not deprecated metrics from user group
subset(ga_meta, group == "User" & type == "METRIC" & status != "DEPRECATED", id)
# get parameters allowed in segments
subset(ga_meta, allowed.in.segments, id)
}
}
\references{
\href{https://developers.google.com/analytics/devguides/reporting/metadata/v3/}{Google Analytics Metadata API}

\href{https://developers.google.com/analytics/devguides/reporting/core/dimsmets}{Core Reporting API - Dimensions & Metrics Reference}
}
\seealso{
\code{\link{shiny_dimsmets}} \code{\link{get_ga}}
}

