/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection.booleanfunction;

import freak.core.control.Schedule;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;

public class CreateNewIndividuals
extends Selection
implements Configurable {
    private int noOfNewInd = 1;

    public CreateNewIndividuals(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
    }

    public IndividualList[] process(IndividualList[] original) {
        IndividualList[] result = new IndividualList[]{original[0]};
        int i = original.length;
        while (i < original.length + this.noOfNewInd) {
            BooleanFunction bfs = (BooleanFunction)this.graph.getSchedule().getGenotypeSearchSpace();
            BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)bfs.getRandomGenotype();
            Individual ind = new Individual(this.graph.getSchedule(), bfg, new Individual[0]);
            result[0].addIndividual(ind);
            ++i;
        }
        return result;
    }

    public Integer getPropertyNoOfNewInd() {
        return new Integer(this.noOfNewInd);
    }

    public void setPropertyNoOfNewInd(Integer noOfNewInd) {
        if (noOfNewInd >= 0) {
            this.noOfNewInd = noOfNewInd;
        }
    }

    public String getShortDescriptionForNoOfNewInd() {
        return "New individuals";
    }

    public String getLongDescriptionForNoOfNewInd() {
        return "The number of new individuals to create.";
    }

    public String getName() {
        return "CreateNewIndividuals";
    }

    public String getDescription() {
        return "Creates new individuals and puts them at the end of the given individual list.";
    }
}

