/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover;

import freak.core.graph.DifferentNumberOfIndividualsException;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Recombination;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BooleanFunctionGenotype;
import java.util.Iterator;

public abstract class MultiPairwiseCrossover
extends Recombination {
    public MultiPairwiseCrossover(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addInPort();
        super.addOutPort();
    }

    protected abstract Individual doCrossover(Individual var1, Individual var2);

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        IndividualList[] output = new IndividualList[1];
        if (input[0].size() != input[1].size()) {
            BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)input[0].getIndividual(0).getGenotype();
            BooleanFunctionGenotype bfg2 = (BooleanFunctionGenotype)input[1].getIndividual(0).getGenotype();
            throw new DifferentNumberOfIndividualsException("Both individual lists must have the same number of individuals,  but the sizes are " + input[0].size() + " and " + input[1].size() + "." + bfg.getPopulation() + " " + bfg2.getPopulation());
        }
        output[0] = new Population(this.graph.getSchedule(), input[0].size());
        Iterator[] it = new Iterator[]{input[0].iterator(), input[1].iterator()};
        while (it[0].hasNext()) {
            output[0].addIndividual(this.doCrossover((Individual)it[0].next(), (Individual)it[1].next()));
        }
        return output;
    }
}

