/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.utilities;

public abstract class LeaseManager
extends Thread {
    private long term;
    private long expiration;
    private long remainingTime;

    public LeaseManager(long l) {
        this.term = l;
        this.renew();
        this.start();
    }

    public abstract void evict();

    public abstract boolean offerRenewal();

    public synchronized void renew() {
        this.expiration = System.currentTimeMillis() + this.term;
        this.remainingTime = this.term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.remainingTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LeaseManager leaseManager = this;
            synchronized (leaseManager) {
                this.remainingTime = this.expiration - System.currentTimeMillis();
                if (this.remainingTime < 0L && !this.offerRenewal()) {
                    this.evict();
                    break;
                }
            }
        }
    }
}

