/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Exponential
extends AbstractContinousDistribution {
    protected double lambda;
    protected static Exponential shared = new Exponential(1.0, AbstractDistribution.makeDefaultGenerator());

    public Exponential(double lambda, RandomElement randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(lambda);
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x * this.lambda);
    }

    public double nextDouble() {
        return this.nextDouble(this.lambda);
    }

    public double nextDouble(double lambda) {
        return -Math.log(this.randomGenerator.raw()) / lambda;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-x * this.lambda);
    }

    public void setState(double lambda) {
        this.lambda = lambda;
    }

    public static double staticNextDouble(double lambda) {
        Exponential exponential = shared;
        synchronized (exponential) {
            return shared.nextDouble(lambda);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.lambda + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomGenerator) {
        Exponential exponential = shared;
        synchronized (exponential) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

