/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

public class WELL512
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064359965952E-10;
    private static final int W = 32;
    private static final int R = 16;
    private static final int P = 0;
    private static final int M1 = 13;
    private static final int M2 = 9;
    private static final int M3 = 5;
    private static final int MASK = 15;
    private int state_i;
    private int[] state;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream;
    private static BitMatrix Apw;
    private static BitMatrix Apz;
    private static boolean initialised;
    private static final int[] pw;
    private static final int[] pz;

    private static void initialisation() {
        curr_stream = new int[]{-1555972198, -1343975397, 1796267544, 100537376, -460645732, 1493885278, -974421337, 938128121, -1864251670, 988166402, 1935526172, -1876018548, 1823640157, -2072713263, -2076311133, 1517514991};
        initialised = true;
    }

    private void advanceSeed(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[16];
        for (n = 0; n < 16; ++n) {
            this.state[n] = nArray[n];
        }
        this.state_i = 0;
        for (n = 0; n < 16; ++n) {
            int n2 = nArray2[n];
            for (int i = 0; i < 32; ++i) {
                if ((n2 & 1) == 1) {
                    for (int j = 0; j < 16; ++j) {
                        int n3 = j;
                        nArray3[n3] = nArray3[n3] ^ this.state[this.state_i + j & 0xF];
                    }
                }
                n2 >>= 1;
                this.nextValue();
            }
        }
        for (n = 0; n < 16; ++n) {
            nArray[n] = nArray3[n];
        }
    }

    private static void verifySeed(int[] nArray) {
        if (nArray.length != 16) {
            throw new IllegalArgumentException("Seed must contain 16values");
        }
        for (int i = 0; i < 16; ++i) {
            if (nArray[i] == 0) continue;
            return;
        }
        throw new IllegalArgumentException("At least one of the element of the seed must not be 0.");
    }

    private WELL512(int n) {
        this.state = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.state[i] = 0;
        }
        this.state[n / 32] = 1 << n % 32;
        this.state_i = 0;
    }

    public WELL512() {
        if (!initialised) {
            WELL512.initialisation();
        }
        this.state = new int[16];
        this.stream = new int[16];
        this.substream = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, pz);
        this.resetStartStream();
    }

    public WELL512(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        WELL512.verifySeed(nArray);
        for (int i = 0; i < 16; ++i) {
            WELL512.curr_stream[i] = nArray[i];
        }
    }

    public void setSeed(int[] nArray) {
        WELL512.verifySeed(nArray);
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = this.state[this.state_i + i & 0xF];
        }
        return nArray;
    }

    public WELL512 clone() {
        WELL512 wELL512 = null;
        wELL512 = (WELL512)super.clone();
        wELL512.state = new int[16];
        wELL512.substream = new int[16];
        wELL512.stream = new int[16];
        for (int i = 0; i < 16; ++i) {
            wELL512.state[i] = this.state[i];
            wELL512.substream[i] = this.substream[i];
            wELL512.stream[i] = this.stream[i];
        }
        return wELL512;
    }

    public void resetStartStream() {
        for (int i = 0; i < 16; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 0;
        for (int i = 0; i < 16; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, pw);
        this.resetStartSubstream();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name == null) {
            stringBuffer.append("The state of this WELL512 is : {");
        } else {
            stringBuffer.append("The state of " + this.name + " is : {");
        }
        for (int i = 0; i < 15; ++i) {
            stringBuffer.append(this.state[this.state_i + i & 0xF] + ", ");
        }
        stringBuffer.append(this.state[this.state_i + 16 - 1 & 0xF] + "}");
        return stringBuffer.toString();
    }

    protected double nextValue() {
        int n = this.state[this.state_i + 15 & 0xF];
        int n2 = this.state[this.state_i] ^ this.state[this.state_i] << 16 ^ (this.state[this.state_i + 13 & 0xF] ^ this.state[this.state_i + 13 & 0xF] << 15);
        int n3 = this.state[this.state_i + 9 & 0xF] ^ this.state[this.state_i + 9 & 0xF] >>> 11;
        this.state[this.state_i] = n2 ^ n3;
        this.state[this.state_i + 15 & 0xF] = n ^ n << 2 ^ (n2 ^ n2 << 18) ^ n3 << 28 ^ (this.state[this.state_i] ^ this.state[this.state_i] << 5 & 0xDA442D24);
        this.state_i = this.state_i + 15 & 0xF;
        long l = this.state[this.state_i];
        return (double)(l > 0L ? l : l + 0x100000000L) * 2.3283064359965952E-10;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Must provide the output file.");
            System.exit(1);
        }
        System.out.println("Creating the WELL512 state transition matrices.");
        BitVector[] bitVectorArray = new BitVector[512];
        int[] nArray = new int[16];
        for (int i = 0; i < 512; ++i) {
            WELL512 wELL512 = new WELL512(i);
            wELL512.nextValue();
            for (int j = 0; j < 16; ++j) {
                nArray[j] = wELL512.state[wELL512.state_i + j & 0xF];
            }
            bitVectorArray[i] = new BitVector(nArray, 512);
        }
        BitMatrix bitMatrix = new BitMatrix(bitVectorArray).transpose();
        BitMatrix bitMatrix2 = bitMatrix.power2e(200);
        BitMatrix bitMatrix3 = bitMatrix2.power2e(150);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(bitMatrix2);
            objectOutputStream.writeObject(bitMatrix3);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't create " + stringArray[0]);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        initialised = false;
        pw = new int[]{671091113, 836903376, -1609825642, 1983727915, 1669815157, -282407878, 335578015, 1577878822, 85254427, 1454610660, -1808348999, -1495788789, -1062958472, 648894416, -1549744598, 1072786587};
        pz = new int[]{-848760066, 406754970, 1979992494, -1441995442, -78421073, 2044652187, -278477546, 271926219, 609032855, 1970322577, 824197063, 1163829962, -679660931, -658069444, -988084761, 806098177};
    }
}

