/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ParetoDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public ParetoDist(double d) {
        this.setParams(d, 1.0);
    }

    public ParetoDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return ParetoDist.density(this.alpha, this.beta, d);
    }

    public double cdf(double d) {
        return ParetoDist.cdf(this.alpha, this.beta, d);
    }

    public double barF(double d) {
        return ParetoDist.barF(this.alpha, this.beta, d);
    }

    public double inverseF(double d) {
        return ParetoDist.inverseF(this.alpha, this.beta, d);
    }

    public double getMean() {
        return ParetoDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return ParetoDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return ParetoDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d3 < d2 ? 0.0 : d * Math.pow(d2 / d3, d) / d3;
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= d2) {
            return 0.0;
        }
        if (d3 >= Double.MAX_VALUE) {
            return 1.0;
        }
        return 1.0 - Math.pow(d2 / d3, d);
    }

    public static double barF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < d2) {
            return 1.0;
        }
        return Math.pow(d2 / d3, d);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d3 <= 0.0) {
            return d2;
        }
        double d4 = -Math.log1p(-d3);
        if (d3 >= 1.0 || d4 / Math.log(10.0) >= d * 308.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d2 / Math.pow(1.0 - d3, 1.0 / d);
    }

    public static double[] getMLE(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[2];
        dArray2[1] = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] < dArray2[1])) continue;
            dArray2[1] = dArray[i];
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] > 0.0) {
                d += Math.log(dArray[i] / dArray2[1]);
                continue;
            }
            d -= 709.0;
        }
        dArray2[0] = (double)n / d;
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return ParetoDist.getMLE(dArray, n);
    }

    public static ParetoDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = ParetoDist.getMaximumLikelihoodEstimate(dArray, n);
        return new ParetoDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("alpha <= 1");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d * d2 / (d - 1.0);
    }

    public static double getVariance(double d, double d2) {
        if (d <= 2.0) {
            throw new IllegalArgumentException("alpha <= 2");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d * d2 * d2 / ((d - 2.0) * (d - 1.0) * (d - 1.0));
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(ParetoDist.getVariance(d, d2));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = d;
        this.beta = d2;
        this.supportA = d2;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.alpha, this.beta};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }
}

