/*
 * Decompiled with CFR 0.152.
 */
package javalain.ea.operator;

import javalain.ea.Solution;
import javalain.math.fonction.Fct;

public final class Crossover {
    private static final double EPS = 1.0E-14;

    public static Solution[] SBX(double Pc, Solution p1, Solution p2, Fct fct, double Nc) {
        Solution e1 = new Solution(p1.getVariable());
        Solution e2 = new Solution(p2.getVariable());
        if (Math.random() <= Pc) {
            for (int i = 0; i < p1.getNbVariable(); ++i) {
                double x1 = p1.getVariable(i);
                double x2 = p2.getVariable(i);
                if (Math.random() <= 0.5) {
                    if (Math.abs(x1 - x2) > 1.0E-14) {
                        double beta;
                        double alpha;
                        if (x1 > x2) {
                            double min = x2;
                            x2 = x1;
                            x1 = min;
                        }
                        double inf = fct.getLowerLimit(i);
                        double sup = fct.getUpperLimit(i);
                        double rnd = Math.random();
                        double betaq = rnd <= 1.0 / (alpha = 2.0 - Math.pow(beta = 1.0 + 2.0 * (x1 - inf) / (x2 - x1), -(Nc + 1.0))) ? Math.pow(rnd * alpha, 1.0 / (Nc + 1.0)) : Math.pow(1.0 / (2.0 - rnd * alpha), 1.0 / (Nc + 1.0));
                        double c1 = 0.5 * (x1 + x2 - betaq * (x2 - x1));
                        beta = 1.0 + 2.0 * (sup - x2) / (x2 - x1);
                        alpha = 2.0 - Math.pow(beta, -(Nc + 1.0));
                        betaq = rnd <= 1.0 / alpha ? Math.pow(rnd * alpha, 1.0 / (Nc + 1.0)) : Math.pow(1.0 / (2.0 - rnd * alpha), 1.0 / (Nc + 1.0));
                        double c2 = 0.5 * (x1 + x2 + betaq * (x2 - x1));
                        if (c1 < inf) {
                            c1 = inf;
                        } else if (c1 > sup) {
                            c1 = sup;
                        }
                        if (c2 < inf) {
                            c2 = inf;
                        } else if (c2 > sup) {
                            c2 = sup;
                        }
                        if (Math.random() <= 0.5) {
                            e1.setVariable(i, c2);
                            e2.setVariable(i, c1);
                            continue;
                        }
                        e1.setVariable(i, c1);
                        e2.setVariable(i, c2);
                        continue;
                    }
                    e1.setVariable(i, x1);
                    e2.setVariable(i, x2);
                    continue;
                }
                e1.setVariable(i, x2);
                e2.setVariable(i, x1);
            }
        }
        Solution[] enfants = new Solution[]{e1, e2};
        return enfants;
    }
}

