% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cosslett.R
\name{Cosslett}
\alias{Cosslett}
\title{Kiefer-Wolfowitz estimator for Cosslett (1983) estimator}
\usage{
Cosslett(x, y, v = 300, weights = NULL, ...)
}
\arguments{
\item{x}{is the observed utility difference between two choices, it would be
possible to extend this to make x a linear (index) function of some parameters}

\item{y}{is the binary outcome}

\item{v}{the unobserved utility difference taking values on a grid, by default
this grid is equally spaced with 300 distinct points, however it is known that
the mass points for the problem are located at the data points, x, so users may
wish to set \code{v = sort(x)} although if the sample size is large this can be
slow.}

\item{weights}{replicate weights for x observations, should sum to 1}

\item{...}{optional parameters to be passed to KWDual to control optimization}
}
\value{
an object of class density with the components:
	\item{x}{points of evaluation of the mixing density} 
	\item{y}{function values of the mixing density at x} 
	\item{logL}{log likelihood of estimated model} 
\item{status}{exit code from the optimizer}
}
\description{
Kiefer-Wolfowitz-Cosslett  estimator for binary response model.
}
\details{
In the primal form of the problem the pseudo log likelihood is:

\deqn{l(f|y) =  sum_i [ y_i \log \sum_j (I(v_j <= x_i) * f_j) + 
		(1 - y_i) \log \sum_j (I(v_j > x_i) * f_j) ]}

as usual the implementation used here solves the corresponding dual problem.
Cumsum of the output y gives the CDF of the unobserved utility difference.
See the \code{demo(Cosslett1)}and  \code{demo(Cosslett2)} for illustrations
without any covariate, and \code{demo(Cosslett3)} for an illustration with a
covariate using profile likelihood.  This model is also known as current
status linear regression in the biostatistics literature, see e.g. Groeneboom
and Hendrickx (2016) for recent results and references.
}
\references{
Kiefer, J. and J. Wolfowitz (1956) Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters, \emph{Ann. Math. Statist}, 27, 887-906.

Cosslett, S. (1983) Distribution Free Maximum Likelihood Estimator of the 
Binary Choice Model, \emph{Econometrica}, 51, 765-782.

Groeneboom, P. and K. Hendrickx (2016) Current Status Linear Regression,
preprint available from \url{https://arxiv.org/abs/1601.00202}.
}
\author{
Jiaying Gu and Roger Koenker
}
\keyword{nonparametric}
