% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCarb-package.R
\docType{data}
\name{Reference_Data}
\alias{Reference_Data}
\title{Reference data}
\format{
\code{Reference_Data}: \link{list} \cr

\tabular{llll}{
\strong{NAME} \tab \strong{TYPE} \tab \strong{DIM} \tab \strong{DESCRIPTION}\cr
\code{DATAek} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for electrons for water and carbonate to sediment mass ratio for K\cr
\code{DATAet} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for electrons for water and carbonate to sediment mass ratio for Th \cr
\code{DATAet230} 	\tab \code{matrix} \tab 4 x 4 \tab correction factors for electrons for water and carbonate to sediment mass ratio for Th-230\cr
\code{DATAeu} 	\tab \code{matrix} \tab 4 x 4 \tab correction factors for electrons for water and carbonate to sediment mass ratio for U\cr
\code{DATAeu234} 	\tab \code{matrix} \tab 4 x 4 \tab correction factors for electrons for water and carbonate to sediment mass ratio for U-234\cr
\code{DATAeu238} 	\tab \code{matrix} \tab 4 x 4 \tab correction factors for electrons for water and carbonate to sediment mass ratio for U-238\cr
\code{DATApk} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for photons for water and carbonate to sediment mass ratio for K\cr
\code{DATApt} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for photons for water and carbonate to sediment mass ratio for T\cr
\code{DATApt230} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for photons for water and carbonate to sediment mass ratio for Th-230\cr
\code{DATApu} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for photons for water and carbonate to sediment mass ratio for U\cr
\code{DATApu234} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for photons for water and carbonate to sediment mass ratio for U-234\cr
\code{DATApu238} \tab	 \code{matrix} \tab 4 x 4 \tab correction factors for photons for water and carbonate to sediment mass ratio for U-238\cr
\code{mejdahl} \tab	 \code{data.frame} \tab 36 x 4 \tab beta-dose attenuation values for quartz grains according to Mejdahl (1979) \cr
\code{DR_conv_factors} \tab \code{data.frame} \tab 4 x 13 \tab beta and gamma dose rate conversion factors used internally (see details)
}
}
\description{
Reference data and correction factors for beta and gamma radiation used for internal calculations.
These values are used instead of the correction factors given in Aitken (1985) for the carbonate model.
}
\details{
The reference values are used internally to account for: (1) grain size depend beta-attenuation
factors (Mejdahl, 1979) and (2) to correct nuclide dependent beta and gamma radiation for water/carbonate proportions.
The latter values are given as matrix and precise values are interpolated during the modelling process.

Additionally 'RCarb' provides and own set of dose rate conversion factors to convert concentrations
of U, Th, and K to dose rate values. Historically \emph{Carb} (and thus 'RCarb') as its own dose rate
conversion factors, which differ slightly from other published values. To provide a consistent
calculation approach by default the 'old' \emph{Carb} values are used, but the user can further
switch (see \link{model_DoseRate}) to values provided by Adamiec \& Aitken (1998), Guérin et al. (2011)
or Liritzis et al (2013).

Different values quoted for U-238 and U-234 accounts for different activity ratios. For further details
on the origin of these data we refer to Nathan \& Mauz (2008) and Nathan (2010).\cr

\strong{Nuclear data origin according to Nathan \& Mauz (2008)}

The gamma primary energy spectra of uranium, thorium and potassium are drawn from
Evaluated Nuclear Structure Data File (ENSDF) database at \url{http://www.nndc.bnl.gov} (2002-01-16)
and the beta primary energy spectra was derived from ENSDF end-point energies using a
Fermi beta decay model (Evans, 1955) modified by Behrens \& Szybisz (1976).
For the simulations of the collisional mass stopping powers for quartz the software ESTAR
(Berger et al., 2000) was used. The mass energy-absorption coefficients for quartz were
tabulated by Hubbell \& Seltzer (2004).

\emph{For further details and references please read Nathan \& Mauz (2008)}
}
\section{Version}{
 0.2.0
}

\examples{

data(Reference_Data, envir = environment())
str(Reference_Data)
Reference_Data$DATAek

}
\references{
Adamiec, G., Aitken, M.J., 1998. Dose-rate conversion factors: update.
Ancient TL 16, 37–50. \url{http://ancienttl.org/ATL_16-2_1998/ATL_16-2_Adamiec_p37-50.pdf}

Guérin, G., Mercier, N., Adamiec, G., 2011. Dose-rate conversion factors: update. Ancient TL 29, 5–9.
\url{http://ancienttl.org/ATL_29-1_2011/ATL_29-1_Guerin_p5-8.pdf}

Liritzis, I., Stamoulis, K., Papachristodoulou, C., Ioannides, K., 2013.
A Re-Evaluation of Radiation Dose-Rate Conversion Factors.
Mediterranean Archaeology and Archaeometry 12, 1–15.
\url{http://maajournal.com/Issues/2012/pdf/FullTextLiritzis.pdf}

Mejdahl, V., 1979. Thermoluminescence dating: beta-dose attenuation in quartz grains. Archaeometry 21, 61-72.
\url{http://ancienttl.org/ATL_32-2_2014/ATL_32-2_Mauz_p24-32.pdf}

Nathan, R.P., Mauz, B., 2008. On the dose-rate estimate of carbonate-rich sediments for trapped charge dating.
Radiation Measurements 43, 14-25. \doi{10.1016/j.radmeas.2007.12.012}

Nathan, R.P., 2010. Numerical modelling of environmental dose rate and its application to trapped-charge dating.
DPhil thesis, St Hugh's College, Oxford. \url{https://ora.ox.ac.uk/objects/ora:6421}\cr

\strong{Further reading}

Aitken, M.J., 1985. Thermoluminescence dating. Academic Press.

Berger, M.J., Coursey, J.S., Zucker, M.A., 2000. ESTAR, PSTAR, and
ASTAR: Computer Programs for Calculating Stopping-Power and Range
Tables for Electrons, Protons, and Helium Ions (version 1.2.2).
http://physics.nist.gov/Star (2005-08-09).
National Institute of Standards and Technology, Gaithersburg, MD.

Behrens, H., Szybisz, L., 1976. Shapes of beta spectra. Physics Data 6-1,
Zentralstelle fuer Atomkernenergie-Dokumentation (ZAED), Germany.

Evans, R.D., 1955. The Atomic Nucleus. McGraw-Hill, NY.

Hubbell, J.H., Seltzer, S.M., 2004. Tables of X-Ray Mass Attenuation Coefficients and Mass
Energy-Absorption Coefficients (version 1.4). http://physics.nist.gov/xaamdi
(2005-08-09). National Institute of Standards and Technology, Gaithersburg, MD.
}
\keyword{datasets}
