% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{DGM}
\alias{DGM}
\title{Generating RCT data or observational data for the examples used in the package}
\usage{
DGM(
  trial,
  n,
  var_name,
  p_success,
  tau,
  y0,
  log.ps = NULL,
  binary = FALSE,
  noise = 1,
  ...
)
}
\arguments{
\item{trial}{Logical indicating whether the treatment is randomly assigned in the generated data. If TRUE, RCT data is generated. Otherwise, observational data is generated.}

\item{n}{A numeric value indicating the number of observations in the generated data}

\item{var_name}{A character vector indicating the names of variables}

\item{p_success}{the success probability of binary variables}

\item{tau}{a character indicating the generation of the true treatment effect of each individual}

\item{y0}{a character indicating the generation of the potential outcome under control}

\item{log.ps}{a numeric value indicating the logit of propensity score}

\item{binary}{logical indicating whether the outcome is binary or continuous variable}

\item{noise}{a numeric value indicating the standard error of noise term of continuous outcome}

\item{...}{an optional argument indicating pairwise correlations between variables}
}
\value{
a data frame; column names are variables names, z, y
}
\description{
Generating RCT data or observational data for the examples used in the package
}
\examples{
n_rct <- 500; n_rwd <- 500
var_name <- c("x1","x2","x3","x4","x5","x6")
p_success_rct <- c(0.7,0.9,0.2,0.3,0.2,0.3)
p_success_rwd <- c(0.2,0.2,0.8,0.8,0.7,0.8)
tau <- "6*x2+x6+2"
y0 <- "x1"
log.ps <- "x1*x2+x3*x4+5*x5+x6"
rho1 <- c("x1","x2",0)
rho2 <- c("x2","x3",0)

target.data <- RCTrep::DGM(trial=TRUE, n_rct, var_name,
                           p_success_rct, tau, y0, log.ps=0,
                           binary = FALSE, noise=1, rho1, rho2)
source.data <- RCTrep::DGM(trial=FALSE, n_rwd, var_name,
                           p_success_rwd, tau, y0, log.ps,
                           binary = FALSE, noise=1, rho1, rho2)


}
