% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFileInfo.R
\name{getFileInfo}
\alias{getFileInfo}
\title{List all CMIP5 files in a directory tree}
\usage{
getFileInfo(path = ".", recursive = TRUE)
}
\arguments{
\item{path}{string root of directory tree}

\item{recursive}{logical. Should the listing recurse into directories?}
}
\value{
data.frame containing the following parsed from file names:
\item{filename}{Full filename, including path}
\item{variable}{File variable}
\item{domain}{File domain}
\item{model}{Model that produced this file}
\item{experiment}{File experiment}
\item{ensemble}{File ensemble}
\item{time}{year (and often month) range of file}
\item{size}{File size, in kilobytes}
}
\description{
List all CMIP5 files in a directory tree, parsing their filenames for
information like experiment, model, and variable names.
}
\details{
For more information on CMIP5 filename structure and data description,
see \url{http://cmip-pcmdi.llnl.gov/cmip5/data_description.html}
}
\examples{
getFileInfo()
getFileInfo('.', recursive=FALSE)
}
\seealso{
\code{\link{checkTimePeriod}}
}

