% Generated by roxygen2 (4.0.1): do not edit by hand
\name{restoreMissingDims}
\alias{restoreMissingDims}
\title{Restore missing and/or degenerate dimensions in the data}
\usage{
restoreMissingDims(dims, dimNames, lonArr, latArr, ZArr, thisTimeRaw, verbose)
}
\arguments{
\item{dims}{the data array just loaded from the netcdf}

\item{dimNames}{vector of dimensions names present in file}

\item{lonArr}{numeric vector of longitude values}

\item{latArr}{numeric vector of latitude values}

\item{ZArr}{numeric vector of Z values}

\item{thisTimeRaw}{numeric vector of time values}

\item{verbose}{logical. Print info as we go?}
}
\value{
The data array with restored dimensions.
}
\description{
Restore missing and/or degenerate dimensions in the data
}
\note{
There are two cases to consider here. (1) If we load a dimension with only
one value (one month, one depth, etc) then that dimension will be dropped by
the .ncvar_get function (there's a 'collapse_degen' option available in ncdf4,
but not in ncdf). (2) A dimension is missing entirely, e.g. in a time-only file,
or a space-only grid area file. In either case, we want those dimensions (of
length 1) back in the data array.

This is an internal RCMIP5 function and not exported.
}
\keyword{internal}

