% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_useful_functions.R
\name{estNetwork}
\alias{estNetwork}
\title{Function to estimate & plot haplotype network}
\usage{
estNetwork(
  blockInterest = NULL,
  gwasRes = NULL,
  nTopRes = 1,
  gene.set = NULL,
  indexRegion = 1:10,
  chrInterest = NULL,
  posRegion = NULL,
  blockName = NULL,
  pheno = NULL,
  geno = NULL,
  ZETA = NULL,
  chi2Test = TRUE,
  thresChi2Test = 0.05,
  plotNetwork = TRUE,
  distMat = NULL,
  distMethod = "manhattan",
  evolutionDist = FALSE,
  complementHaplo = "phylo",
  subpopInfo = NULL,
  groupingMethod = "kmedoids",
  nGrp = 3,
  nIterClustering = 100,
  iterRmst = 100,
  networkMethod = "rmst",
  autogamous = FALSE,
  probParsimony = 0.95,
  nMaxHaplo = 1000,
  kernelTypes = "addNOIA",
  nCores = parallel::detectCores(),
  hOpt = "optimized",
  hOpt2 = "optimized",
  maxIter = 20,
  rangeHStart = 10^c(-1:1),
  saveName = NULL,
  saveStyle = "png",
  plotWhichMDS = 1:2,
  colConnection = c("grey40", "grey60"),
  ltyConnection = c("solid", "dashed"),
  lwdConnection = c(1.5, 0.8),
  pchBase = c(1, 16),
  colCompBase = c(2, 4),
  colHaploBase = c(3, 5, 6),
  cexMax = 2,
  cexMin = 0.7,
  ggPlotNetwork = FALSE,
  cexMaxForGG = 0.025,
  cexMinForGG = 0.008,
  alphaBase = c(0.9, 0.3),
  verbose = TRUE
)
}
\arguments{
\item{blockInterest}{A \eqn{n \times M} matrix representing the marker genotype that belongs to the haplotype block of interest.
If this argument is NULL, this argument will automatically be determined by `geno`,}

\item{gwasRes}{You can use the results (data.frame) of haplotype-based (SNP-set) GWAS by `RGWAS.multisnp` function.}

\item{nTopRes}{Haplotype blocks (or gene sets, SNP-sets) with top `nTopRes` p-values by `gwasRes` will be used.}

\item{gene.set}{If you have information of gene (or haplotype block), you can use it to perform kernel-based GWAS.
You should assign your gene information to gene.set in the form of a "data.frame" (whose dimension is (the number of gene) x 2).
In the first column, you should assign the gene name. And in the second column, you should assign the names of each marker,
which correspond to the marker names of "geno" argument.}

\item{indexRegion}{You can specify the haplotype block (or gene set, SNP-set) of interest by the marker index in `geno`.}

\item{chrInterest}{You can specify the haplotype block (or gene set, SNP-set) of interest by the marker position in `geno`.
Please assign the chromosome number to this argument.}

\item{posRegion}{You can specify the haplotype block (or gene set, SNP-set) of interest by the marker position in `geno`.
Please assign the position in the chromosome to this argument.}

\item{blockName}{You can specify the haplotype block (or gene set, SNP-set) of interest by the name of haplotype block in `geno`.}

\item{pheno}{Data frame where the first column is the line name (gid). 
The remaining columns should be a phenotype to test.}

\item{geno}{Data frame with the marker names in the first column. The second and third columns contain the chromosome and map position.
Columns 4 and higher contain the marker scores for each line, coded as {-1, 0, 1} = {aa, Aa, AA}.}

\item{ZETA}{A list of covariance (relationship) matrix (K: \eqn{m \times m}) and its design matrix (Z: \eqn{n \times m}) of random effects.
Please set names of list "Z" and "K"! You can use more than one kernel matrix.
For example,

ZETA = list(A = list(Z = Z.A, K = K.A), D = list(Z = Z.D, K = K.D))
\describe{
\item{Z.A, Z.D}{Design matrix (\eqn{n \times m}) for the random effects. So, in many cases, you can use the identity matrix.}
\item{K.A, K.D}{Different kernels which express some relationships between lines.}
}
For example, K.A is additive relationship matrix for the covariance between lines, and K.D is dominance relationship matrix.}

\item{chi2Test}{If TRUE, chi-square test for the relationship between haplotypes & subpopulations will be performed.}

\item{thresChi2Test}{The threshold for the chi-square test.}

\item{plotNetwork}{If TRUE, the function will return the plot of haplotype network.}

\item{distMat}{You can assign the distance matrix of the block of interest. 
If NULL, the distance matrix will be computed in this function.}

\item{distMethod}{You can choose the method to calculate distance between accessions.
This argument corresponds to the `method` argument in the `dist` function.}

\item{evolutionDist}{If TRUE, the evolution distance will be used instead of the pure distance.
The `distMat` will be converted to the distance matrix by the evolution distance when you use `complementHaplo = "phylo"`.}

\item{complementHaplo}{how to complement unobserved haplotypes.
When `complementHaplo = "all"`, all possible haplotypes will be complemented from the observed haplotypes.
When `complementHaplo = "never"`, unobserved haplotypes will not be complemented.
When `complementHaplo = "phylo"`, unobserved haplotypes will be complemented as nodes of phylogenetic tree.
When `complementHaplo = "TCS"`, unobserved haplotypes will be complemented by TCS methods (Clement et al., 2002).}

\item{subpopInfo}{The information of subpopulations. This argument should be a vector of factor.}

\item{groupingMethod}{If `subpopInfo` argument is NULL, this function estimates subpopulation information from marker genotype.
You can choose the grouping method from `kmeans`, `kmedoids`, and `hclust`.}

\item{nGrp}{The number of groups (or subpopulations) grouped by `groupingMethod`.
If this argument is 0, the subpopulation information will not be estimated.}

\item{nIterClustering}{If `groupingMethod` = `kmeans`, the clustering will be performed multiple times.
This argument specifies the number of classification performed by the function.}

\item{iterRmst}{The number of iterations for RMST (randomized minimum spanning tree).}

\item{networkMethod}{Either one of 'mst' (minimum spanning tree),
'msn' (minimum spanning network), and 'rmst' (randomized minimum spanning tree).
'rmst' is recommended.}

\item{autogamous}{This argument will be valid only when you use `complementHaplo = "all"` or `complementHaplo = "TCS"`.
This argument specifies whether the plant is autogamous or not. If autogamous = TRUE, 
complemented haplotype will consist of only homozygous sites ({-1, 1}). 
If FALSE, complemented haplotype will consist of both homozygous & heterozygous sites ({-1, 0, 1}).}

\item{probParsimony}{Equal to the argument `prob` in `haplotypes::parsimnet` function: 

A numeric vector of length one in the range [0.01, 0.99] giving the probability of parsimony as defined in Templeton et al. (1992). 
In order to set maximum connection steps to Inf (to connect all the haplotypes in a single network), set the probability to NULL.}

\item{nMaxHaplo}{The maximum number of haplotypes. If the number of total (complemented + original) haplotypes are larger than `nMaxHaplo`, 
we will only show the results only for the original haplotypes to reduce the computational time.}

\item{kernelTypes}{In the function, similarlity matrix between accessions will be computed from marker genotype to estimate genotypic values.
This argument specifies the method to compute similarity matrix: 
If this argument is `addNOIA` (or one of other options in `methodGRM` in `calcGRM`), 
then the `addNOIA` (or corresponding) option in the `calcGRM` function will be used,
and if this argument is `diffusion`, the diffusion kernel based on Laplacian matrix will be computed from network.
You can assign more than one kernelTypes for this argument; for example, kernelTypes = c("addNOIA", "diffusion").}

\item{nCores}{The number of cores used for optimization.}

\item{hOpt}{Optimized hyper parameter for constructing kernel when estimating haplotype effects.
If hOpt = "optimized", hyper parameter will be optimized in the function.
If hOpt is numeric, that value will be directly used in the function.}

\item{hOpt2}{Optimized hyper parameter for constructing kernel when estimating complemented haplotype effects.
If hOpt2 = "optimized", hyper parameter will be optimized in the function.
If hOpt2 is numeric, that value will be directly used in the function.}

\item{maxIter}{Max number of iterations for optimization algorithm.}

\item{rangeHStart}{The median of off-diagonal of distance matrix multiplied by rangeHStart will be used 
as the initial values for optimization of hyper parameters.}

\item{saveName}{When drawing any plot, you can save plots in png format. In saveName, you should substitute the name you want to save.
When saveName = NULL, the plot is not saved.}

\item{saveStyle}{This argument specifies how to save the plot of phylogenetic tree.
The function offers `png`, `pdf`, `jpg`, and `tiff`.}

\item{plotWhichMDS}{We will show the MDS (multi-dimensional scaling) plot, 
and this argument is a vector of two integers specifying that will define which MDS dimension will be plotted.
The first and second integers correspond to the horizontal and vertical axes, respectively.}

\item{colConnection}{A vector of two integers or characters specifying the colors of connection between nodes for the original and complemented haplotypes, respectively.}

\item{ltyConnection}{A vector of two characters specifying the line types of connection between nodes for the original and complemented haplotypes, respectively.}

\item{lwdConnection}{A vector of two integers specifying the line widths of connection between nodes for the original and complemented haplotypes, respectively.}

\item{pchBase}{A vector of two integers specifying the plot types for the positive and negative genotypic values respectively.}

\item{colCompBase}{A vector of two integers or characters specifying color of complemented haplotypes for the positive and negative genotypic values respectively.}

\item{colHaploBase}{A vector of integers or characters specifying color of original haplotypes for the positive and negative genotypic values respectively.
The length of the vector should equal to the number of subpopulations.}

\item{cexMax}{A numeric specifying the maximum point size of the plot.}

\item{cexMin}{A numeric specifying the minimum point size of the plot.}

\item{ggPlotNetwork}{If TRUE, the function will return the ggplot version of haplotype network. 
It offers the precise information on subgroups for each haplotype.}

\item{cexMaxForGG}{A numeric specifying the maximum point size of the plot for the ggplot version of haplotype network,
relative to the range of x and y-axes (0 < cexMaxForGG <= 1).}

\item{cexMinForGG}{A numeric specifying the minimum point size of the plot for the ggplot version of haplotype network,
relative to the range of x and y-axes (0 < cexMaxForGG <= 1).}

\item{alphaBase}{alpha (parameter that indicates the opacity of a geom) for original haplotype with positive / negative effects.
alpha for complemented haplotype will be same as the alpha for original haplotype with negative effects.}

\item{verbose}{If this argument is TRUE, messages for the current steps will be shown.}
}
\value{
\describe{A list / lists of 
\item{$haplotypeInfo}{\describe{A list of haplotype information with 
\item{$haploCluster}{A vector indicating each individual belongs to which haplotypes.}
\item{$haploBlock}{Marker genotype of haplotype block of interest for the representing haplotypes.}
}
}
\item{$subpopInfo}{The information of subpopulations.}
\item{$pValChi2Test}{A p-value of the chi-square test for the dependency between haplotypes & subpopulations.
If `chi2Test = FALSE`, `NA` will be returned.}
\item{$mstResults}{\describe{A list of estimated results of MST / MSN / RMST: 
\item{$mstRes}{Estimated results of MST / MSN / RMST for the data including original haplotypes.}
\item{$mstResComp}{Estimated results of MST / MSN / RMST for the data including both original and complemented haplotype.}
}
}
\item{$distMats}{\describe{A list of distance matrix: 
\item{$distMat}{Distance matrix between haplotypes.}
\item{$distMatComp}{Distance matrix between haplotypes (including unobserved ones).}
\item{$laplacianMat}{Laplacian matrix between haplotypes (including unobserved ones).}
}
}
\item{$gvTotal}{Estimated genotypic values by kernel regression for each haplotype.}
\item{$gvTotalForLine}{Estimated genotypic values by kernel regression for each individual.}
\item{$minuslog10p}{\eqn{-log_{10}(p)} for haplotype block of interest.
 p is the p-value for the siginifacance of the haplotype block effect.}
\item{$hOpts}{Optimized hyper parameters, hOpt1 & hOpt2.}
\item{$EMMResults}{\describe{A list of estimated results of kernel regression: 
\item{$EM3Res}{Estimated results of kernel regression for the estimation of haplotype effects. (1st step)}
\item{$EMMRes}{Estimated results of kernel regression for the estimation of haplotype effects of nodes. (2nd step)}
\item{$EMM0Res}{Estimated results of kernel regression for the null model.}
}
}
\item{$clusterNosForHaplotype}{A list of cluster Nos of individuals that belong to each haplotype.}
}
}
\description{
Function to estimate & plot haplotype network
}
