% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{zipFastener}
\alias{zipFastener}
\title{Combine two dataframes like a zip-fastener}
\usage{
zipFastener(df1, df2, along = 2)
}
\arguments{
\item{df1}{A first dataframe.}

\item{df2}{A second dataframe with the same dimensions as \code{df1}.}

\item{along}{\code{1} to alternate rows or \code{2} to alternate columns.}
}
\value{
A dataframe with combined rows (or columns) of df1 and df2.
}
\description{
Combine rows or columns of two dataframes in an alternating manner
}
\examples{
# data frames equal dimensions
df1 <- plyr::rdply(3, rep('o',4))[ ,-1]
df2 <- plyr::rdply(3, rep('X',4))[ ,-1]

zipFastener(df1, df2)
zipFastener(df1, df2, 2)
zipFastener(df1, df2, 1)

# data frames unequal in no. of rows
df1 <- plyr::rdply(10, rep('o',4))[ ,-1]
zipFastener(df1, df2, 1)
zipFastener(df2, df1, 1)

# data frames unequal in no. of columns
df2 <- plyr::rdply(10, rep('X',3))[ ,-1]
zipFastener(df1, df2)
zipFastener(df2, df1, 2)

}
\author{
Mark Heckmann
}
