% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_summaries.R
\name{summary.flFitLinear}
\alias{summary.flFitLinear}
\title{Generic summary function for flFitLinear objects}
\usage{
\method{summary}{flFitLinear}(object, ...)
}
\arguments{
\item{object}{object of class \code{flFitLinear}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters extracted from a linear fit.
}
\description{
Generic summary function for flFitLinear objects
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file('lac_promoters.xlsx', package = 'QurvE'),
                   data.fl = system.file('lac_promoters.xlsx', package = 'QurvE'),
                   sheet.growth = 1,
                   sheet.fl = 2 )

# Extract time and normalized fluorescence data for single sample
time <- input$time[4,]
data <- input$norm.fluorescence[4,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- flFitLinear(time = time,
                       fl_data = data,
                       ID = 'TestFit',
                       control = fl.control(fit.opt = 'l', x_type = 'time',
                       lin.R2 = 0.95, lin.RSD = 0.1,
                       lin.h = 20))

summary(TestFit)
}
