% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{FullEM}
\alias{FullEM}
\title{Expectation Maximization algorithm}
\usage{
FullEM(Schrod, nclust, prior_center, prior_weight = NULL, contamination,
  epsilon = 5 * 10^(-3), optim = "default")
}
\arguments{
\item{Schrod}{A list of dataframes (one for each sample), generated by the Patient_schrodinger_cellularities() function.}

\item{nclust}{Number of clones to look for (mandatory if prior_center or prior_weight are null)}

\item{prior_center}{Clone coordinates (from another analysis) to be used}

\item{prior_weight}{Prior on the fraction of mutation in each clone}

\item{contamination}{Numeric vector with the fraction of normal cells contaminating the sample}

\item{epsilon}{Stopping condition for the algorithm: what is the minimal tolerated difference of position 
or weighted between two steps}

\item{optim}{use L-BFS-G optimization from R ("default"), or from optimx ("optimx"), or Differential Evolution ("DEoptim")}
}
\description{
Optimization of clone positions and proportion of mutations in each clone followed 
by filtering on most likely possibility for each mutation and a re-optimization.
}
\keyword{EM}
