# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generic back test function
#'
#' @name back_test
#' @param enter bool vector of length n of enter signals
#' @param exit bool vector of length n of exit signals
#' @param price numeric vector of length n of prices
#' @param stop_loss relative stop loss, must be negative
#' @param side direction of enter order, \code{-1}:short, \code{1}:long
#' @description Back test by enter and exit signals with stop loss on price history. Execution is immediate. Useful for testing on daily data.
#' @return trades data.table with columns \code{ price_enter,price_exit,mtm_min,mtm_max,id_enter,id_exit,pnl_trade,side}
#' @export
back_test <- function(enter, exit, price, stop_loss = -1000, side = 1L) {
    .Call('QuantTools_back_test', PACKAGE = 'QuantTools', enter, exit, price, stop_loss, side)
}

#' Bollinger Bands
#'
#' @name bbands
#' @param x numeric vectors
#' @param n window size
#' @param k number of standard deviations
#' @family technical indicators
#' @return
#' Returns data.table with columns \code{upper, lower, sma}.
#' @description Bollinger bands is a mix of Rolling Range and SMA indicators. It shows the average price and its range over n past values based on price volatility.
#' @export
bbands <- function(x, n, k) {
    .Call('QuantTools_bbands', PACKAGE = 'QuantTools', x, n, k)
}

#' Crossover
#'
#' @name crossover
#' @param x,y numeric vectors
#' @family technical indicators
#' @description Crossover is binary indicator indicating the moment when one value goes above or below another.
#' @export
crossover <- function(x, y) {
    .Call('QuantTools_crossover', PACKAGE = 'QuantTools', x, y)
}

#' Exponential Moving Average
#'
#' @param x numeric vectors
#' @param n window size
#' @family technical indicators
#' @description Exponentially weighted moving average aka EMA is exponentially weighted SMA. EMAs have faster response to recent value changes than SMAs.
#' @export
ema <- function(x, n) {
    .Call('QuantTools_ema', PACKAGE = 'QuantTools', x, n)
}

na_locf_numeric <- function(x) {
    .Call('QuantTools_na_locf_numeric', PACKAGE = 'QuantTools', x)
}

#' Rolling Linear Regression
#'
#' @name roll_lm
#' @param n window size
#' @param x,y numeric vectors
#' @family technical indicators
#' @return roll_lm returns data.table with columns \code{alpha, beta, r, r.squared}
#' @description Rolling linear regression calculates regression coefficients over n past paired values.
#' \cr Others return numeric vector
#' @export
roll_lm <- function(x, y, n) {
    .Call('QuantTools_roll_lm', PACKAGE = 'QuantTools', x, y, n)
}

#' @rdname roll_lm
#' @export
roll_correlation <- function(x, y, n) {
    .Call('QuantTools_roll_correlation', PACKAGE = 'QuantTools', x, y, n)
}

#' Rolling Percent Rank
#'
#' @name roll_percent_rank
#' @param x numeric vector
#' @param n window size
#' @family technical indicators
#' @description Rolling percent rank normalizes values to a range from 0 to 100.
#' @export
roll_percent_rank <- function(x, n) {
    .Call('QuantTools_roll_percent_rank', PACKAGE = 'QuantTools', x, n)
}

#' Rolling Range
#'
#' @name roll_range
#' @param x numeric vectors
#' @param n window size
#' @param p probability value \code{[0, 1]}
#' @family technical indicators
#' @return
#' roll_range returns data.table with columns \code{min, max}
#' \cr others return numeric vector
#' @description Rolling range is minimum and maximum values over n past values. Can be used to identify price range.
#' @export
roll_range <- function(x, n) {
    .Call('QuantTools_roll_range', PACKAGE = 'QuantTools', x, n)
}

#' @rdname roll_range
#' @export
roll_quantile <- function(x, n, p) {
    .Call('QuantTools_roll_quantile', PACKAGE = 'QuantTools', x, n, p)
}

#' @rdname roll_range
#' @export
roll_min <- function(x, n) {
    .Call('QuantTools_roll_min', PACKAGE = 'QuantTools', x, n)
}

#' @rdname roll_range
#' @export
roll_max <- function(x, n) {
    .Call('QuantTools_roll_max', PACKAGE = 'QuantTools', x, n)
}

#' Rolling Filter
#'
#' @name roll_sd_filter
#' @param x numeric vector
#' @param n window size
#' @param k number of standard deviations
#' @param m number of consequent large returns to stop filtering out
#' @description Logical vector is returned. This function is useful to filter ticks. Finds consequent elements which absolute change is higher than k standard deviation of past n changes and mark them \code{FALSE}. If sequence length greater than \code{m} values become \code{TRUE}.
#' @export
roll_sd_filter <- function(x, n, k = 1, m = 10L) {
    .Call('QuantTools_roll_sd_filter', PACKAGE = 'QuantTools', x, n, k, m)
}

#' Rolling Standard Deviation
#'
#' @name roll_sd
#' @param x numeric vector
#' @param n window size
#' @family technical indicators
#' @description Rolling standard deviation shows standard deviation over n past values.
#' @export
roll_sd <- function(x, n) {
    .Call('QuantTools_roll_sd', PACKAGE = 'QuantTools', x, n)
}

#' Rolling Volume Profile
#'
#' @name roll_volume_profile
#' @param ticks read 'Ticks' section in \link{Processor}
#' @param timeFrame indicator period in seconds, when to apply alpha correction
#' @param step price round off value, bar width
#' @param alpha multiplication coefficient must be between (0,1]
#' @param cut threshold volume when to delete bar
#' @return data.table with columns \code{time, profile} where profile is data.table with columns \code{time, price, volume}
#' @description This indicator is not common. Volume profile is the distribution of volume over price. It is formed tick by tick and partially forgets past values over time interval. When volume on any bar is lower than specified critical value the bar is cut.
#' @family technical indicators
#' @export
roll_volume_profile <- function(ticks, timeFrame, step, alpha, cut) {
    .Call('QuantTools_roll_volume_profile', PACKAGE = 'QuantTools', ticks, timeFrame, step, alpha, cut)
}

#' Relative Strength Index
#'
#' @param x numeric vectors
#' @param n window size
#' @family technical indicators
#' @description Relative strength index aka RSI measures the velocity and magnitude of directional price movements.
#' @export
rsi <- function(x, n) {
    .Call('QuantTools_rsi', PACKAGE = 'QuantTools', x, n)
}

run_tests <- function() {
    .Call('QuantTools_run_tests', PACKAGE = 'QuantTools')
}

#' Simple Moving Average
#'
#' @param x numeric vectors
#' @param n window size
#' @family technical indicators
#' @description Simple moving average also called SMA is the most popular indicator. It shows the average of n past values. Can be used for time series smoothing.
#' @export
sma <- function(x, n) {
    .Call('QuantTools_sma', PACKAGE = 'QuantTools', x, n)
}

#' Stochastic
#'
#' @name stochastic
#' @param n window size
#' @param x \code{high, low, close} data.frame or numeric vector
#' @param nFast fast smooth
#' @param nSlow slow smooth
#' @family technical indicators
#' @return data.table with columns \code{k_fast, d_fast, d_slow}
#' @description Stochastic oscillator shows position of price in respect to its range over n past values.
#' @export
stochastic <- function(x, n, nFast, nSlow) {
    .Call('QuantTools_stochastic', PACKAGE = 'QuantTools', x, n, nFast, nSlow)
}

#' Convert ticks to candles
#'
#' @name to_candles
#' @param ticks read 'Ticks' section in \link{Processor}
#' @param timeframe candle timeframe in seconds
#' @return data.table with columns \code{time, open, high, low, close, volume, id}. Where \code{id} is row number of last tick in candle. \cr
#' Note: last candle is always omitted.
#' @rdname to_candles
#' @export
to_candles <- function(ticks, timeframe) {
    .Call('QuantTools_to_candles', PACKAGE = 'QuantTools', ticks, timeframe)
}

