% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{discount.time}
\alias{discount.time}
\title{Quantil's discount time convention}
\usage{
discount.time(tinitial, tfinal)
}
\arguments{
\item{tinitial}{Initial date of analysis.}

\item{tfinal}{Final date of analysis.}
}
\value{
Number of years between the specified dates.
}
\description{
Function to count the number of years between dates according
to Quantil's discount convention. A year is defined as the difference in one year,
between two dates with the exact month and day. Meanwhile, partial years are defined as the
quotient between the number of elapsed days within a year and the total number of days that
make up that year. Total number of years between the two dates is then the sum between complete full
years and the partial portion.
}
\details{
There is an exception. For example, for initial date 29-February, a year is defined as the
28 of February of the next year. Meanwhile four years, is defined as 29 of February four years after.
}
\examples{
discount.time(tinitial = "2024-07-13", tfinal = "2025-03-01")
discount.time(tinitial = "2024-02-29", tfinal = "2025-02-28")
discount.time(tinitial = "2024-02-29", tfinal = "2028-02-29")

}
