% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_value.R
\name{cv_ksample}
\alias{cv_ksample}
\title{Compute the critical value for the KBQD k-sample tests}
\usage{
cv_ksample(x, y, h, B = 150, b = 0.9, Quantile = 0.95, method = "subsampling")
}
\arguments{
\item{x}{matrix containing the observations to be used in the k-sample test}

\item{y}{vector indicating the sample for each observation}

\item{h}{the tuning parameter for the test using the Gaussian kernel}

\item{B}{the number of bootstrap/permutation/subsampling samples to generate}

\item{b}{the subsampling block size (only used if \code{method} is "subsampling")}

\item{Quantile}{the quantile of the bootstrap/permutation/subsampling distribution to use as the critical value}

\item{method}{the method to use for computing the critical value (one of "bootstrap", "permutation")}
}
\value{
a vector of two critical values corresponding to different formulation of the k-sample test statistics.
}
\description{
This function computes the empirical critical value for the k-sample KBQD tests using the
centered Gaussian kernel, with bootstrap, permutation, or subsampling.
}
\keyword{internal}
