% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.Qindex.R
\name{predict.Qindex}
\alias{predict.Qindex}
\title{Predicted Sign-Adjusted Quantile Indices}
\usage{
\method{predict}{Qindex}(object, newdata = object@gam$data, ...)
}
\arguments{
\item{object}{an \linkS4class{Qindex} object based on the training set.}

\item{newdata}{test \link[base]{data.frame}, with at least
the response \eqn{y^{\text{new}}} and
the \link[base]{double} \link[base]{matrix} of
functional predictor values \eqn{X^{\text{new}}}
of the test set, tabulated on the same \eqn{x}-grid as the training set \eqn{X}.
If missing, the training set \code{object@gam$data} will be used.}

\item{...}{additional parameters, currently not in use.}
}
\value{
Function \link{predict.Qindex} returns a
\link[base]{double} \link[base]{vector},
which is the predicted sign-adjusted quantile indices on the test set.
}
\description{
To predict sign-adjusted quantile indices of a test set.
}
\details{
Function \link{predict.Qindex} computes
the predicted sign-adjusted quantile indices on the test set,
which is
the product of function \link[mgcv]{predict.gam} return
and the correlation sign based on training set
(\code{object@sign}, see Step 3 of section \strong{Details} of function \link{Qindex}).
Multiplication by \code{object@sign} is required to ensure
that the predicted sign-adjusted quantile indices
are positively associated with the \strong{training} functional predictor values
at the selected tabulating grid.
}
