% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBC_dichotom.R
\name{BBC_dichotom}
\alias{BBC_dichotom}
\title{Bootstrap-based Optimism Corrected Optimal Dichotomization}
\usage{
BBC_dichotom(formula, data, contX, ...)
}
\arguments{
\item{formula}{\link[stats]{formula}, left-hand-side being the endpoint and
right-hand-side being the predictors \emph{in addition to} the \link[base]{numeric} predictor(s) to be dichotomized.
If there is no additional predictors, use \code{y ~ 1}}

\item{data}{\link[base]{data.frame}}

\item{contX}{\link[base]{character} scalar,
name of the \link[base]{matrix} column in \code{data}
which contains the \link[base]{numeric} predictor(s) to be dichotomized}

\item{...}{additional parameters of \link[boot]{boot}, most importantly the number of bootstrap replicates \code{R}}
}
\value{
\link{BBC_dichotom} returns a \link[base]{numeric} bootstrap-based bias adjusted
coefficients of a \link[survival]{coxph}, \link[stats]{glm} or \link[stats]{lm} regression model,
with \link[base]{attributes}
\describe{
\item{\code{attr(,'median_optimism')}}{the returned object from \link{boot_optim_dichotom}}
\item{\code{attr(,'apparent_branch')}}{a \link[base]{list} of \link[base]{language} objects, branches of the apparent model}
}
}
\description{
Bootstrap-based optimism correction for optimal dichotomization of selected \link[base]{numeric} predictor(s).
}
\details{
The \emph{apparent performance estimate} are the coefficients
of the regression model with dichotomized predictors (via \link{coef_dichotom})
fitted to the entire data set.

The \emph{optimism-corrected performance estimate} is computed by subtracting the
median optimism estimate (via \link{boot_optim_dichotom}) from the apparent performance estimate.
}
\examples{
# see ?`Qindex-package`

}
\references{
Ewout W. Steyerberg (2009) Clinical Prediction Models.
\doi{10.1007/978-0-387-77244-8}

Frank E. Harrell Jr., Kerry L. Lee, Daniel B. Mark. (1996) Multivariable prognostic models: issues in developing models, evaluating
assumptions and adequacy, and measuring and reducing errors.
\doi{10.1002/(SICI)1097-0258(19960229)15:4<361::AID-SIM168>3.0.CO;2-4}
}
