% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_germplasm_attributes}
\alias{get_germplasm_attributes}
\title{Retrieve Attributes for a Specified Germplasm}
\usage{
get_germplasm_attributes(germplasm_name = "")
}
\arguments{
\item{germplasm_name}{The name of the germplasm.}
}
\value{
A data frame containing the attributes of the specified germplasm.
}
\description{
Retrieve Attributes for a Specified Germplasm
}
\examples{
if (interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Log in using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # Retrieve attribute data of a specified germplasm in a crop
  germplasm_attributes <- get_germplasm_attributes("Jabal")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{get_germplasm_data}}
}
\author{
Johan Steven Aparicio, \email{j.aparicio@cgiar.org}
}
