% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_pedigree_table}
\alias{get_pedigree_table}
\title{Get the Pedigree Table}
\usage{
get_pedigree_table(
  data,
  geno_column = "germplasmName",
  pedigree_column = "pedigree"
)
}
\arguments{
\item{data}{germplasm dataset as a data.frame.}

\item{geno_column}{name of the column that identifies the genotype/germplasm names.}

\item{pedigree_column}{name of the column that identifies the pedigree strings.}
}
\value{
A data.frame that has three columns correspond to the identifiers for the individual,
        female parent and male parent, respectively. The row giving the pedigree of an
        individual appears before any row where that individual appears as a parent.
        Founders use NA in the parental columns.
}
\description{
Get the pedigree table starting from current germplasm list and associated
pedigree string that provides the parentage through which a cultivar was obtained.
}
\examples{
if(interactive()) {
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")

# select a specific environment/location dataset
set_study("2018 PVT Environment Number 1")

# retrieve the germplasm list of the selected environment/location
germplasm <- get_germplasm_list()

pedigree_table <- get_pedigree_table(germplasm, "germplasmName", "pedigree")

#############################
# nadiv package way
# library(nadiv)

# get additive relationship matrix in sparse matrix format
# A <- nadiv::makeA(pedigree_table)

# get A inverse matrix using base R function
# AINV <- solve(as.matrix(A))

#############################
# ASReml-R package way
# library(asreml)

# represent A inverse matrix in efficient way using i,j index and Ainverse value
# actual genotype names of any given index are in the attr(ainv, "rowNames")
# ainv <- asreml::ainverse(pedigree_table)

#############################
# dummy data set for testing
test <- data.frame(genotype = c("X", "Y"),
                   pedigree = c("A//B/D/2/C", "B/C/3/A//B/C/2/D"))

pedigree_table <- get_pedigree_table(test, "genotype", "pedigree")
}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
