% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PyGet.R
\name{pyGet}
\alias{pyGet}
\title{Gets Python objects by name and transforms them into R objects}
\usage{
pyGet(key, autoTypecast = TRUE, simplify = TRUE)
}
\arguments{
\item{key}{a string specifying the name of a Python object.}

\item{autoTypecast}{an optional logical value, default is TRUE, specifying
if the return values should be automatically typecasted if possible.}

\item{simplify}{an optional logical value, if TRUE R converts Python lists
into R vectors whenever possible, else it translates Python lists
always into R lists.}
}
\value{
Returns the specified Python object converted into an R object if
        possible, else a virtual Python object.
}
\description{
The function pyGet gets Python objects by name and transforms
             them into R objects.
}
\details{
Since any Python object can be transformed into one of the basic
         data types it is up to the user to do so up front. More information
         about the type conversion can be found in the README file or at
         \url{http://pythoninr.bitbucket.org/}. \cr
}
\note{
pyGet always returns a new object, if you want to create a R representation
      of an existing Python object use pyGet0 instead.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
## get a character of length 1
pyGet("__name__")
## get a character of length 1 > 1
pyGet("sys.path")
## get a list
pyGet("sys.path", simplify = FALSE)
## get a PythonInR_List
x <- pyGet("sys.path", autoTypecast = FALSE)
x
class(x)

## get an object where no specific transformation to R is defined
## this example also shows the differnces between pyGet and pyGet0
pyExec("import datetime")
## pyGet creates a new Python variable where the return value of pyGet is
## stored the name of the new reference is stored in x$py.variableName.
x <- pyGet("datetime.datetime.now().time()")
x
class(x)
x$py.variableName
## pyGet0 never creates a new Python object, objects which can be transformed
## to R objects are transformed. For all other objects an PythonInR_Object is created.
y <- pyGet0("datetime.datetime.now().time()")
y
## An important difference is that the evaluation of x always will return the same
## time, the evaluation of y always will give the new time.
}

